/* mouseAPSetEventMap.c was originally generated by the autoSql program, which also 
 * generated mouseAPSetEventMap.h and mouseAPSetEventMap.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "mouseAPSetEventMap.h"


struct mouseAPSetEventMap *mouseAPSetEventMapLoad(char **row)
/* Load a mouseAPSetEventMap from row fetched with select * from mouseAPSetEventMap
 * from database.  Dispose of this with mouseAPSetEventMapFree(). */
{
struct mouseAPSetEventMap *ret;

AllocVar(ret);
ret->incCount = sqlUnsigned(row[2]);
ret->geneCount = sqlUnsigned(row[4]);
ret->geneName = cloneString(row[0]);
ret->skipPSet = cloneString(row[1]);
{
int sizeOne;
sqlStringDynamicArray(row[3], &ret->incPSets, &sizeOne);
assert(sizeOne == ret->incCount);
}
{
int sizeOne;
sqlStringDynamicArray(row[5], &ret->genePSets, &sizeOne);
assert(sizeOne == ret->geneCount);
}
return ret;
}

struct mouseAPSetEventMap *mouseAPSetEventMapLoadAll(char *fileName) 
/* Load all mouseAPSetEventMap from a whitespace-separated file.
 * Dispose of this with mouseAPSetEventMapFreeList(). */
{
struct mouseAPSetEventMap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = mouseAPSetEventMapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct mouseAPSetEventMap *mouseAPSetEventMapLoadAllByChar(char *fileName, char chopper) 
/* Load all mouseAPSetEventMap from a chopper separated file.
 * Dispose of this with mouseAPSetEventMapFreeList(). */
{
struct mouseAPSetEventMap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = mouseAPSetEventMapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct mouseAPSetEventMap *mouseAPSetEventMapLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all mouseAPSetEventMap from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with mouseAPSetEventMapFreeList(). */
{
struct mouseAPSetEventMap *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = mouseAPSetEventMapLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void mouseAPSetEventMapSaveToDb(struct sqlConnection *conn, struct mouseAPSetEventMap *el, char *tableName, int updateSize)
/* Save mouseAPSetEventMap as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */
{
struct dyString *update = dyStringNew(updateSize);
char  *incPSetsArray, *genePSetsArray;
incPSetsArray = sqlStringArrayToString(el->incPSets, el->incCount);
genePSetsArray = sqlStringArrayToString(el->genePSets, el->geneCount);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s',%u,'%s',%u,'%s')", 
	tableName,  el->geneName,  el->skipPSet,  el->incCount,  incPSetsArray ,  el->geneCount,  genePSetsArray );
sqlUpdate(conn, update->string);
dyStringFree(&update);
freez(&incPSetsArray);
freez(&genePSetsArray);
}


struct mouseAPSetEventMap *mouseAPSetEventMapCommaIn(char **pS, struct mouseAPSetEventMap *ret)
/* Create a mouseAPSetEventMap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new mouseAPSetEventMap */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->geneName = sqlStringComma(&s);
ret->skipPSet = sqlStringComma(&s);
ret->incCount = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->incPSets, ret->incCount);
for (i=0; i<ret->incCount; ++i)
    {
    ret->incPSets[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->geneCount = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->genePSets, ret->geneCount);
for (i=0; i<ret->geneCount; ++i)
    {
    ret->genePSets[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void mouseAPSetEventMapFree(struct mouseAPSetEventMap **pEl)
/* Free a single dynamically allocated mouseAPSetEventMap such as created
 * with mouseAPSetEventMapLoad(). */
{
struct mouseAPSetEventMap *el;

if ((el = *pEl) == NULL) return;
freeMem(el->geneName);
freeMem(el->skipPSet);
/* All strings in incPSets are allocated at once, so only need to free first. */
if (el->incPSets != NULL)
    freeMem(el->incPSets[0]);
freeMem(el->incPSets);
/* All strings in genePSets are allocated at once, so only need to free first. */
if (el->genePSets != NULL)
    freeMem(el->genePSets[0]);
freeMem(el->genePSets);
freez(pEl);
}

void mouseAPSetEventMapFreeList(struct mouseAPSetEventMap **pList)
/* Free a list of dynamically allocated mouseAPSetEventMap's */
{
struct mouseAPSetEventMap *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    mouseAPSetEventMapFree(&el);
    }
*pList = NULL;
}

void mouseAPSetEventMapOutput(struct mouseAPSetEventMap *el, FILE *f, char sep, char lastSep) 
/* Print out mouseAPSetEventMap.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->skipPSet);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->incCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->incCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->incPSets[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
fprintf(f, "%u", el->geneCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->geneCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->genePSets[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

