/* bdgpExprLink.h was originally generated by the autoSql program, which also 
 * generated bdgpExprLink.c and bdgpExprLink.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2003 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef BDGPEXPRLINK_H
#define BDGPEXPRLINK_H

#define BDGPEXPRLINK_NUM_COLS 9

struct bdgpExprLink
/* Summary info for linking to the BDGP Expression In Situ Images site */
    {
    struct bdgpExprLink *next;  /* Next in singly linked list. */
    char *symbol;	/* Symbolic gene name */
    char *bdgpName;	/* BDGP gene ID */
    char *flyBaseId;	/* FlyBase gene ID */
    char *est;	/* EST accession */
    int imageCount;	/* Number of images for this gene */
    int bodyPartCount;	/* Number of body parts */
    char *plate;	/* DGC Plate */
    int platePos;	/* Position on plate */
    char newRelease;	/* 'Y' if this gene is a new release */
    };

void bdgpExprLinkStaticLoad(char **row, struct bdgpExprLink *ret);
/* Load a row from bdgpExprLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bdgpExprLink *bdgpExprLinkLoad(char **row);
/* Load a bdgpExprLink from row fetched with select * from bdgpExprLink
 * from database.  Dispose of this with bdgpExprLinkFree(). */

struct bdgpExprLink *bdgpExprLinkLoadAll(char *fileName);
/* Load all bdgpExprLink from whitespace-separated file.
 * Dispose of this with bdgpExprLinkFreeList(). */

struct bdgpExprLink *bdgpExprLinkLoadAllByChar(char *fileName, char chopper);
/* Load all bdgpExprLink from chopper separated file.
 * Dispose of this with bdgpExprLinkFreeList(). */

#define bdgpExprLinkLoadAllByTab(a) bdgpExprLinkLoadAllByChar(a, '\t');
/* Load all bdgpExprLink from tab separated file.
 * Dispose of this with bdgpExprLinkFreeList(). */

struct bdgpExprLink *bdgpExprLinkCommaIn(char **pS, struct bdgpExprLink *ret);
/* Create a bdgpExprLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bdgpExprLink */

void bdgpExprLinkFree(struct bdgpExprLink **pEl);
/* Free a single dynamically allocated bdgpExprLink such as created
 * with bdgpExprLinkLoad(). */

void bdgpExprLinkFreeList(struct bdgpExprLink **pList);
/* Free a list of dynamically allocated bdgpExprLink's */

void bdgpExprLinkOutput(struct bdgpExprLink *el, FILE *f, char sep, char lastSep);
/* Print out bdgpExprLink.  Separate fields with sep. Follow last field with lastSep. */

#define bdgpExprLinkTabOut(el,f) bdgpExprLinkOutput(el,f,'\t','\n');
/* Print out bdgpExprLink as a line in a tab-separated file. */

#define bdgpExprLinkCommaOut(el,f) bdgpExprLinkOutput(el,f,',',',');
/* Print out bdgpExprLink as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BDGPEXPRLINK_H */

