/* bigTransMap.h was originally generated by the autoSql program, which also 
 * generated bigTransMap.c and bigTransMap.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BIGTRANSMAP_H
#define BIGTRANSMAP_H

#define BIGTRANSMAP_NUM_COLS 40

extern char *bigTransMapCommaSepFieldNames;

struct bigTransMap
/* bigPsl derived pairwise alignment with additional information */
    {
    struct bigTransMap *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* alignment Id */
    unsigned score;	/* Score (0-1000), faction identity * 1000 */
    char strand[2];	/* + or - indicates whether the query aligns to the + or - strand on the reference */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* RGB value (use R,G,B string in input file) */
    int blockCount;	/* Number of blocks */
    int *blockSizes;	/* Comma separated list of block sizes */
    int *chromStarts;	/* Start positions relative to chromStart */
    unsigned oChromStart;	/* Start position in other chromosome */
    unsigned oChromEnd;	/* End position in other chromosome */
    char oStrand[2];	/* + or -, - means that psl was reversed into BED-compatible coordinates */
    unsigned oChromSize;	/* Size of other chromosome. */
    int *oChromStarts;	/* Start positions relative to oChromStart or from oChromStart+oChromSize depending on strand */
    char *oSequence;	/* Sequence on other chrom (or edit list, or empty) */
    char *oCDS;	/* CDS in NCBI format */
    unsigned chromSize;	/* Size of target chromosome */
    unsigned match;	/* Number of bases matched. */
    unsigned misMatch;	/*  Number of bases that don't match  */
    unsigned repMatch;	/*  Number of bases that match but are part of repeats  */
    unsigned nCount;	/*  Number of 'N' bases  */
    unsigned seqType;	/* 0=empty, 1=nucleotide, 2=amino_acid */
    char *srcDb;	/* source database */
    char *srcTransId;	/* source transcript id */
    char *srcChrom;	/* source chromosome */
    unsigned srcChromStart;	/* start position in source chromosome */
    unsigned srcChromEnd;	/* end position in source chromosome */
    unsigned srcIdent;	/* source score (fraction identity * 1000) */
    unsigned srcAligned;	/* fraction of source transcript aligned (fraction aligned * 1000) */
    char *geneName;	/* gene name */
    char *geneId;	/* gene id */
    char *geneType;	/* gene type */
    char *transcriptType;	/* transcript type */
    char *chainType;	/* type of chains used for mapping */
    char *commonName;	/* common name */
    char *scientificName;	/* scientific name */
    char *orgAbbrev;	/* organism abbreviation */
    };

struct bigTransMap *bigTransMapLoad(char **row);
/* Load a bigTransMap from row fetched with select * from bigTransMap
 * from database.  Dispose of this with bigTransMapFree(). */

struct bigTransMap *bigTransMapLoadAll(char *fileName);
/* Load all bigTransMap from whitespace-separated file.
 * Dispose of this with bigTransMapFreeList(). */

struct bigTransMap *bigTransMapLoadAllByChar(char *fileName, char chopper);
/* Load all bigTransMap from chopper separated file.
 * Dispose of this with bigTransMapFreeList(). */

#define bigTransMapLoadAllByTab(a) bigTransMapLoadAllByChar(a, '\t');
/* Load all bigTransMap from tab separated file.
 * Dispose of this with bigTransMapFreeList(). */

struct bigTransMap *bigTransMapCommaIn(char **pS, struct bigTransMap *ret);
/* Create a bigTransMap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bigTransMap */

void bigTransMapFree(struct bigTransMap **pEl);
/* Free a single dynamically allocated bigTransMap such as created
 * with bigTransMapLoad(). */

void bigTransMapFreeList(struct bigTransMap **pList);
/* Free a list of dynamically allocated bigTransMap's */

void bigTransMapOutput(struct bigTransMap *el, FILE *f, char sep, char lastSep);
/* Print out bigTransMap.  Separate fields with sep. Follow last field with lastSep. */

#define bigTransMapTabOut(el,f) bigTransMapOutput(el,f,'\t','\n');
/* Print out bigTransMap as a line in a tab-separated file. */

#define bigTransMapCommaOut(el,f) bigTransMapOutput(el,f,',',',');
/* Print out bigTransMap as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BIGTRANSMAP_H */

