/* chainGap.h was originally generated by the autoSql program, which also 
 * generated chainGap.c and chainGap.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2002 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef CHAINGAP_H
#define CHAINGAP_H

struct chainGap
/* alignment block in chain */
    {
    struct chainGap *next;  /* Next in singly linked list. */
    char *tName;	/* Target sequence name */
    unsigned tStart;	/* Alignment start position in target */
    unsigned tEnd;	/* Alignment end position in target */
    unsigned qStart;	/* start in query */
    unsigned chainId;	/* chain id in chain table */
    };

void chainGapStaticLoad(char **row, struct chainGap *ret);
/* Load a row from chainGap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct chainGap *chainGapLoad(char **row);
/* Load a chainGap from row fetched with select * from chainGap
 * from database.  Dispose of this with chainGapFree(). */

struct chainGap *chainGapLoadAll(char *fileName);
/* Load all chainGap from a tab-separated file.
 * Dispose of this with chainGapFreeList(). */

struct chainGap *chainGapCommaIn(char **pS, struct chainGap *ret);
/* Create a chainGap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new chainGap */

void chainGapFree(struct chainGap **pEl);
/* Free a single dynamically allocated chainGap such as created
 * with chainGapLoad(). */

void chainGapFreeList(struct chainGap **pList);
/* Free a list of dynamically allocated chainGap's */

void chainGapOutput(struct chainGap *el, FILE *f, char sep, char lastSep);
/* Print out chainGap.  Separate fields with sep. Follow last field with lastSep. */

#define chainGapTabOut(el,f) chainGapOutput(el,f,'\t','\n');
/* Print out chainGap as a line in a tab-separated file. */

#define chainGapCommaOut(el,f) chainGapOutput(el,f,',',',');
/* Print out chainGap as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* CHAINGAP_H */

