/* gbWarn.h was originally generated by the autoSql program, which also 
 * generated gbWarn.c and gbWarn.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2008 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef GBWARN_H
#define GBWARN_H

#define GBWARN_NUM_COLS 2

enum gbWarnReason
    {
    gbWarnInvitroNorm = 0,
    gbWarnAthRage = 1,
    gbWarnOrestes = 2,
    };
struct gbWarn
/* warnings about particular clones in GenBank */
    {
    struct gbWarn *next;  /* Next in singly linked list. */
    char acc[13];	/* Genbank accession */
    enum gbWarnReason reason;	/* reason for warning */
    };

void gbWarnStaticLoad(char **row, struct gbWarn *ret);
/* Load a row from gbWarn table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct gbWarn *gbWarnLoad(char **row);
/* Load a gbWarn from row fetched with select * from gbWarn
 * from database.  Dispose of this with gbWarnFree(). */

struct gbWarn *gbWarnLoadAll(char *fileName);
/* Load all gbWarn from whitespace-separated file.
 * Dispose of this with gbWarnFreeList(). */

struct gbWarn *gbWarnLoadAllByChar(char *fileName, char chopper);
/* Load all gbWarn from chopper separated file.
 * Dispose of this with gbWarnFreeList(). */

#define gbWarnLoadAllByTab(a) gbWarnLoadAllByChar(a, '\t');
/* Load all gbWarn from tab separated file.
 * Dispose of this with gbWarnFreeList(). */

struct gbWarn *gbWarnCommaIn(char **pS, struct gbWarn *ret);
/* Create a gbWarn out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gbWarn */

void gbWarnFree(struct gbWarn **pEl);
/* Free a single dynamically allocated gbWarn such as created
 * with gbWarnLoad(). */

void gbWarnFreeList(struct gbWarn **pList);
/* Free a list of dynamically allocated gbWarn's */

void gbWarnOutput(struct gbWarn *el, FILE *f, char sep, char lastSep);
/* Print out gbWarn.  Separate fields with sep. Follow last field with lastSep. */

#define gbWarnTabOut(el,f) gbWarnOutput(el,f,'\t','\n');
/* Print out gbWarn as a line in a tab-separated file. */

#define gbWarnCommaOut(el,f) gbWarnOutput(el,f,',',',');
/* Print out gbWarn as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* GBWARN_H */

