/* gtexInfo.h was originally generated by the autoSql program, which also 
 * generated gtexInfo.c and gtexInfo.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef GTEXINFO_H
#define GTEXINFO_H

#include "jksql.h"
#include "hdb.h"
#define GTEXINFO_NUM_COLS 4

extern char *gtexInfoCommaSepFieldNames;

struct gtexInfo
/* GTEx general information */
    {
    struct gtexInfo *next;  /* Next in singly linked list. */
    char *version;	/* GTEX data release (e.g. V4, V6) */
    char *releaseDate;	/* Release date */
    double maxScore;	/* Maximum score observed (use to scale display) */
    double maxMedianScore;	/* Maximum score observed for a tissue median (use to scale display) */
    };

void gtexInfoStaticLoad(char **row, struct gtexInfo *ret);
/* Load a row from gtexInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct gtexInfo *gtexInfoLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all gtexInfo from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with gtexInfoFreeList(). */

void gtexInfoSaveToDb(struct sqlConnection *conn, struct gtexInfo *el, char *tableName, int updateSize);
/* Save gtexInfo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct gtexInfo *gtexInfoLoad(char **row);
/* Load a gtexInfo from row fetched with select * from gtexInfo
 * from database.  Dispose of this with gtexInfoFree(). */

struct gtexInfo *gtexInfoLoadAll(char *fileName);
/* Load all gtexInfo from whitespace-separated file.
 * Dispose of this with gtexInfoFreeList(). */

struct gtexInfo *gtexInfoLoadAllByChar(char *fileName, char chopper);
/* Load all gtexInfo from chopper separated file.
 * Dispose of this with gtexInfoFreeList(). */

#define gtexInfoLoadAllByTab(a) gtexInfoLoadAllByChar(a, '\t');
/* Load all gtexInfo from tab separated file.
 * Dispose of this with gtexInfoFreeList(). */

struct gtexInfo *gtexInfoCommaIn(char **pS, struct gtexInfo *ret);
/* Create a gtexInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gtexInfo */

void gtexInfoFree(struct gtexInfo **pEl);
/* Free a single dynamically allocated gtexInfo such as created
 * with gtexInfoLoad(). */

void gtexInfoFreeList(struct gtexInfo **pList);
/* Free a list of dynamically allocated gtexInfo's */

void gtexInfoOutput(struct gtexInfo *el, FILE *f, char sep, char lastSep);
/* Print out gtexInfo.  Separate fields with sep. Follow last field with lastSep. */

#define gtexInfoTabOut(el,f) gtexInfoOutput(el,f,'\t','\n');
/* Print out gtexInfo as a line in a tab-separated file. */

#define gtexInfoCommaOut(el,f) gtexInfoOutput(el,f,',',',');
/* Print out gtexInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* GTEXINFO_H */

#define GTEX_DEFAULT_VERSION    "V6"

void gtexInfoCreateTable(struct sqlConnection *conn, char *table);
/* Create GTEx info table */

double gtexMaxMedianScore(char *version);
/* Retrieve max median score for latest (or named) version */

char *gtexVersionSuffix(char *table);
/* Return version string for a GTEx track table.  For now, just supporting V4 and V6 (default, no suffix )*/                                        

char *gtexVersion(char *table);
/* Return version string based on table suffix */

char *gtexVersionSuffixFromVersion(char *version);
/* Return version table suffix for a version */

char *gtexExprUnit(char *version);
/* Units of gene expression */


