/* rnaGroup.h was originally generated by the autoSql program, which also 
 * generated rnaGroup.c and rnaGroup.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2002 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef RNAGROUP_H
#define RNAGROUP_H

struct rnaGroup
/* Details of grouping of rna in cluster */
    {
    struct rnaGroup *next;  /* Next in singly linked list. */
    char *chrom;	/* Chomosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* Always 1000 */
    char strand[2];	/* + or - */
    unsigned refSeqCount;	/* Number of refSeq mrnas in cluster */
    char **refSeqs;	/* List of refSeq accessions */
    unsigned genBankCount;	/* Number of Genbank mrnas in cluster */
    char **genBanks;	/* List of Genbank accessions */
    unsigned rikenCount;	/* Number of Riken mrnas in cluster */
    char **rikens;	/* List of Riken IDs */
    };

struct rnaGroup *rnaGroupLoad(char **row);
/* Load a rnaGroup from row fetched with select * from rnaGroup
 * from database.  Dispose of this with rnaGroupFree(). */

struct rnaGroup *rnaGroupLoadAll(char *fileName);
/* Load all rnaGroup from a tab-separated file.
 * Dispose of this with rnaGroupFreeList(). */

struct rnaGroup *rnaGroupLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all rnaGroup from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with rnaGroupFreeList(). */

struct rnaGroup *rnaGroupCommaIn(char **pS, struct rnaGroup *ret);
/* Create a rnaGroup out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rnaGroup */

void rnaGroupFree(struct rnaGroup **pEl);
/* Free a single dynamically allocated rnaGroup such as created
 * with rnaGroupLoad(). */

void rnaGroupFreeList(struct rnaGroup **pList);
/* Free a list of dynamically allocated rnaGroup's */

void rnaGroupOutput(struct rnaGroup *el, FILE *f, char sep, char lastSep);
/* Print out rnaGroup.  Separate fields with sep. Follow last field with lastSep. */

#define rnaGroupTabOut(el,f) rnaGroupOutput(el,f,'\t','\n');
/* Print out rnaGroup as a line in a tab-separated file. */

#define rnaGroupCommaOut(el,f) rnaGroupOutput(el,f,',',',');
/* Print out rnaGroup as a comma separated list including final comma. */

#endif /* RNAGROUP_H */

