/* snpSeq.h was originally generated by the autoSql program, which also 
 * generated snpSeq.c and snpSeq.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef SNPSEQ_H
#define SNPSEQ_H

#define SNPSEQ_NUM_COLS 2

struct snpSeq
/* Information about sequences contained in rs_fasta files described in snpExtFile */
    {
    struct snpSeq *next;  /* Next in singly linked list. */
    char *name;	/* rsId of sequence */
    int file_offset;	/* byte offset of sequence in file */
    };

void snpSeqStaticLoad(char **row, struct snpSeq *ret);
/* Load a row from snpSeq table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct snpSeq *snpSeqLoad(char **row);
/* Load a snpSeq from row fetched with select * from snpSeq
 * from database.  Dispose of this with snpSeqFree(). */

struct snpSeq *snpSeqLoadAll(char *fileName);
/* Load all snpSeq from whitespace-separated file.
 * Dispose of this with snpSeqFreeList(). */

struct snpSeq *snpSeqLoadAllByChar(char *fileName, char chopper);
/* Load all snpSeq from chopper separated file.
 * Dispose of this with snpSeqFreeList(). */

#define snpSeqLoadAllByTab(a) snpSeqLoadAllByChar(a, '\t');
/* Load all snpSeq from tab separated file.
 * Dispose of this with snpSeqFreeList(). */

struct snpSeq *snpSeqCommaIn(char **pS, struct snpSeq *ret);
/* Create a snpSeq out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new snpSeq */

void snpSeqFree(struct snpSeq **pEl);
/* Free a single dynamically allocated snpSeq such as created
 * with snpSeqLoad(). */

void snpSeqFreeList(struct snpSeq **pList);
/* Free a list of dynamically allocated snpSeq's */

void snpSeqOutput(struct snpSeq *el, FILE *f, char sep, char lastSep);
/* Print out snpSeq.  Separate fields with sep. Follow last field with lastSep. */

#define snpSeqTabOut(el,f) snpSeqOutput(el,f,'\t','\n');
/* Print out snpSeq as a line in a tab-separated file. */

#define snpSeqCommaOut(el,f) snpSeqOutput(el,f,',',',');
/* Print out snpSeq as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* SNPSEQ_H */

