/* txAliDiff.h was originally generated by the autoSql program, which also 
 * generated txAliDiff.c and txAliDiff.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef TXALIDIFF_H
#define TXALIDIFF_H

#define TXALIDIFF_NUM_COLS 20

extern char *txAliDiffCommaSepFieldNames;

struct txAliDiff
/* Differences between reference genome and transcript sequences */
    {
    struct txAliDiff *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome of ambiguous gap placement region */
    unsigned chromEnd;	/* End position in chromosome of ambiguous gap placement region */
    char *name;	/* Name of item */
    unsigned score;	/* Not used */
    char strand[2];	/* Transcript orientation on genome: + or - */
    unsigned thickStart;	/* Start position of 3'-most location for gaps that can shift position without introducing mismatches */
    unsigned thickEnd;	/* End position of 3'-most gap location for gaps that can shift position without introducing mismatches */
    unsigned reserved;	/* RGB color of this item */
    char *txName;	/* Transcript identifier */
    unsigned txStart;	/* Start position in transcript (of ambiguous gap placement region where applicable) */
    unsigned txEnd;	/* End position in transcript (of ambiguous gap placement region where applicable) */
    unsigned gSkipped;	/* Number of bases skipped on genome, if any */
    unsigned txSkipped;	/* Number of bases skipped on transcript, if any */
    unsigned shiftL;	/* Number of bases that gap can be shifted left on genome with no mismatches */
    unsigned shiftR;	/* Number of bases that gap can be shifted right on genome with no mismatches */
    char *hgvsG;	/* HGVS g. notation of genome change to match transcript */
    char *hgvsCN;	/* HGVS c./n. notation of part of transcript not matched in genome */
    char *hgvsN;	/* HGVS c./n. notation of transcript change to match genome */
    char *hgvsPosCN;	/* HGVS c./n. position range of transcript ambiguous gap placement region */
    };

void txAliDiffStaticLoad(char **row, struct txAliDiff *ret);
/* Load a row from txAliDiff table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct txAliDiff *txAliDiffLoad(char **row);
/* Load a txAliDiff from row fetched with select * from txAliDiff
 * from database.  Dispose of this with txAliDiffFree(). */

struct txAliDiff *txAliDiffLoadAll(char *fileName);
/* Load all txAliDiff from whitespace-separated file.
 * Dispose of this with txAliDiffFreeList(). */

struct txAliDiff *txAliDiffLoadAllByChar(char *fileName, char chopper);
/* Load all txAliDiff from chopper separated file.
 * Dispose of this with txAliDiffFreeList(). */

#define txAliDiffLoadAllByTab(a) txAliDiffLoadAllByChar(a, '\t');
/* Load all txAliDiff from tab separated file.
 * Dispose of this with txAliDiffFreeList(). */

struct txAliDiff *txAliDiffCommaIn(char **pS, struct txAliDiff *ret);
/* Create a txAliDiff out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new txAliDiff */

void txAliDiffFree(struct txAliDiff **pEl);
/* Free a single dynamically allocated txAliDiff such as created
 * with txAliDiffLoad(). */

void txAliDiffFreeList(struct txAliDiff **pList);
/* Free a list of dynamically allocated txAliDiff's */

void txAliDiffOutput(struct txAliDiff *el, FILE *f, char sep, char lastSep);
/* Print out txAliDiff.  Separate fields with sep. Follow last field with lastSep. */

#define txAliDiffTabOut(el,f) txAliDiffOutput(el,f,'\t','\n');
/* Print out txAliDiff as a line in a tab-separated file. */

#define txAliDiffCommaOut(el,f) txAliDiffOutput(el,f,',',',');
/* Print out txAliDiff as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* TXALIDIFF_H */

