/* adjacency.c was originally generated by the autoSql program, which also 
 * generated adjacency.h and adjacency.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "adjacency.h"



char *adjacencyCommaSepFieldNames = "chrom,chromStart,chromEnd,name,score,strand1,strand2,cycle,ordering";

void adjacencyStaticLoad(char **row, struct adjacency *ret)
/* Load a row from adjacency table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand1, sizeof(ret->strand1), row[5]);
safecpy(ret->strand2, sizeof(ret->strand2), row[6]);
ret->cycle = row[7];
ret->ordering = sqlUnsigned(row[8]);
}

struct adjacency *adjacencyLoad(char **row)
/* Load a adjacency from row fetched with select * from adjacency
 * from database.  Dispose of this with adjacencyFree(). */
{
struct adjacency *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand1, sizeof(ret->strand1), row[5]);
safecpy(ret->strand2, sizeof(ret->strand2), row[6]);
ret->cycle = cloneString(row[7]);
ret->ordering = sqlUnsigned(row[8]);
return ret;
}

struct adjacency *adjacencyLoadAll(char *fileName) 
/* Load all adjacency from a whitespace-separated file.
 * Dispose of this with adjacencyFreeList(). */
{
struct adjacency *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = adjacencyLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct adjacency *adjacencyLoadAllByChar(char *fileName, char chopper) 
/* Load all adjacency from a chopper separated file.
 * Dispose of this with adjacencyFreeList(). */
{
struct adjacency *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = adjacencyLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct adjacency *adjacencyCommaIn(char **pS, struct adjacency *ret)
/* Create a adjacency out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new adjacency */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand1, sizeof(ret->strand1));
sqlFixedStringComma(&s, ret->strand2, sizeof(ret->strand2));
ret->cycle = sqlStringComma(&s);
ret->ordering = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void adjacencyFree(struct adjacency **pEl)
/* Free a single dynamically allocated adjacency such as created
 * with adjacencyLoad(). */
{
struct adjacency *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->cycle);
freez(pEl);
}

void adjacencyFreeList(struct adjacency **pList)
/* Free a list of dynamically allocated adjacency's */
{
struct adjacency *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    adjacencyFree(&el);
    }
*pList = NULL;
}

void adjacencyOutput(struct adjacency *el, FILE *f, char sep, char lastSep) 
/* Print out adjacency.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand1);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand2);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cycle);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->ordering);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

