/* barChartCategory.c was originally generated by the autoSql program, which also 
 * generated barChartCategory.h and barChartCategory.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "barChartCategory.h"



char *barChartCategoryCommaSepFieldNames = "id,name,label,color";

void barChartCategoryStaticLoad(char **row, struct barChartCategory *ret)
/* Load a row from barChartCategory table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->label = row[2];
ret->color = sqlUnsigned(row[3]);
}

struct barChartCategory *barChartCategoryLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all barChartCategory from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with barChartCategoryFreeList(). */
{
struct barChartCategory *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = barChartCategoryLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void barChartCategorySaveToDb(struct sqlConnection *conn, struct barChartCategory *el, char *tableName, int updateSize)
/* Save barChartCategory as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s',%u)", 
	tableName,  el->id,  el->name,  el->label,  el->color);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct barChartCategory *barChartCategoryLoad(char **row)
/* Load a barChartCategory from row fetched with select * from barChartCategory
 * from database.  Dispose of this with barChartCategoryFree(). */
{
struct barChartCategory *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->label = cloneString(row[2]);
ret->color = sqlUnsigned(row[3]);
return ret;
}

struct barChartCategory *barChartCategoryLoadAll(char *fileName) 
/* Load all barChartCategory from a whitespace-separated file.
 * Dispose of this with barChartCategoryFreeList(). */
{
struct barChartCategory *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = barChartCategoryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct barChartCategory *barChartCategoryLoadAllByChar(char *fileName, char chopper) 
/* Load all barChartCategory from a chopper separated file.
 * Dispose of this with barChartCategoryFreeList(). */
{
struct barChartCategory *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = barChartCategoryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct barChartCategory *barChartCategoryCommaIn(char **pS, struct barChartCategory *ret)
/* Create a barChartCategory out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new barChartCategory */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->label = sqlStringComma(&s);
ret->color = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void barChartCategoryFree(struct barChartCategory **pEl)
/* Free a single dynamically allocated barChartCategory such as created
 * with barChartCategoryLoad(). */
{
struct barChartCategory *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->label);
freez(pEl);
}

void barChartCategoryFreeList(struct barChartCategory **pList)
/* Free a list of dynamically allocated barChartCategory's */
{
struct barChartCategory *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    barChartCategoryFree(&el);
    }
*pList = NULL;
}

void barChartCategoryOutput(struct barChartCategory *el, FILE *f, char sep, char lastSep) 
/* Print out barChartCategory.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->label);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->color);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#include "hdb.h"

struct hash *barChartCategoriesToHash(struct barChartCategory *categories)
/* Convert a barChartCategory to hash of barChartCategory->name */
{
struct hash *ret = hashNew(0);
struct barChartCategory *cat;
for (cat = categories; cat != NULL; cat = cat->next)
    {
    hashStore(ret, cat->label);
    }
return ret;
}

struct barChartCategory *barChartGetCategories(char *database, char *track)
/* Get id, labels, colors, etc. */
{
char query[1024];
struct sqlConnection *conn = hAllocConn(database);
sqlSafef(query, sizeof(query), "select * from %sCategory order by id", track);
struct barChartCategory *categs = barChartCategoryLoadByQuery(conn, query);
hFreeConn(&conn);
return categs;
}   

char *barChartGetCategoryLabel(int id, char *database, char *track)
/* Get description for a category specified by id.  
 * Use for single queries (o/w use barChartGetCategories) */
{
char query[1024];
struct sqlConnection *conn = hAllocConn(database);
sqlSafef(query, sizeof(query), "select label from %sCategory where id=%d\n", 
                track, id);
char *label = sqlQuickString(conn, query);
hFreeConn(&conn);
return label;
}


