table cgapSageLib
"CGAP SAGE libraries info"
    (
    uint libId;            "Numeric library ID"
    string oldLibName;     "Old library name"
    string newLibName;     "New library name"
    uint totalTags;        "Total tags including linker"
    uint totalTagsNoLinker; "Total tags after eliminating linker"
    uint uniqueTags;       "Unique tags"
    uint quality;          "Library quality"
    string tissue;         "Organ/tissue"
    string tissuePrep;     "Tissue preparation"
    lstring cellType;      "Cell type"
    string keywords;       "Keywords"
    string age;            "Patient age"
    set(male, female) sex; "Patient sex"
    string mutations;      "Mutations"
    lstring otherInfo;     "Other information"
    string tagEnzyme;      "Tagging enzyme"
    string anchorEnzyme;   "Anchoring enzyme"
    string cellSupplier;   "Tissue or cell line supplier"
    string libProducer;    "Library producer"
    string laboratory;     "Laboratory"
    lstring refs;          "References"
    )
