/* chainArrange.h was originally generated by the autoSql program, which also 
 * generated chainArrange.c and chainArrange.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef CHAINARRANGE_H
#define CHAINARRANGE_H

#define CHAINARRANGE_NUM_COLS 12

extern char *chainArrangeCommaSepFieldNames;

struct chainArrange
/* A list of assembly rearrangements */
    {
    struct chainArrange *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome (or contig, scaffold, etc.) */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* Score from 0-1000 */
    char strand[2];	/* + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned itemRgb;	/* Color */
    char *source;	/* List of assemblies where break occures */
    unsigned querySize;	/* size of item on query side */
    char *label;	/* label for item */
    };

void chainArrangeStaticLoad(char **row, struct chainArrange *ret);
/* Load a row from chainArrange table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct chainArrange *chainArrangeLoad(char **row);
/* Load a chainArrange from row fetched with select * from chainArrange
 * from database.  Dispose of this with chainArrangeFree(). */

struct chainArrange *chainArrangeLoadAll(char *fileName);
/* Load all chainArrange from whitespace-separated file.
 * Dispose of this with chainArrangeFreeList(). */

struct chainArrange *chainArrangeLoadAllByChar(char *fileName, char chopper);
/* Load all chainArrange from chopper separated file.
 * Dispose of this with chainArrangeFreeList(). */

#define chainArrangeLoadAllByTab(a) chainArrangeLoadAllByChar(a, '\t');
/* Load all chainArrange from tab separated file.
 * Dispose of this with chainArrangeFreeList(). */

struct chainArrange *chainArrangeCommaIn(char **pS, struct chainArrange *ret);
/* Create a chainArrange out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new chainArrange */

void chainArrangeFree(struct chainArrange **pEl);
/* Free a single dynamically allocated chainArrange such as created
 * with chainArrangeLoad(). */

void chainArrangeFreeList(struct chainArrange **pList);
/* Free a list of dynamically allocated chainArrange's */

void chainArrangeOutput(struct chainArrange *el, FILE *f, char sep, char lastSep);
/* Print out chainArrange.  Separate fields with sep. Follow last field with lastSep. */

#define chainArrangeTabOut(el,f) chainArrangeOutput(el,f,'\t','\n');
/* Print out chainArrange as a line in a tab-separated file. */

#define chainArrangeCommaOut(el,f) chainArrangeOutput(el,f,',',',');
/* Print out chainArrange as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* CHAINARRANGE_H */

