/* ensXRefZfish.c was originally generated by the autoSql program, which also 
 * generated ensXRefZfish.h and ensXRefZfish.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "ensXRefZfish.h"


void ensXRefZfishStaticLoad(char **row, struct ensXRefZfish *ret)
/* Load a row from ensXRefZfish table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->ensGeneId = row[0];
ret->zfinId = row[1];
ret->uniProtId = row[2];
ret->spDisplayId = row[3];
ret->geneId = row[4];
ret->geneSymbol = row[5];
ret->refSeq = row[6];
ret->protAcc = row[7];
ret->description = row[8];
}

struct ensXRefZfish *ensXRefZfishLoad(char **row)
/* Load a ensXRefZfish from row fetched with select * from ensXRefZfish
 * from database.  Dispose of this with ensXRefZfishFree(). */
{
struct ensXRefZfish *ret;

AllocVar(ret);
ret->ensGeneId = cloneString(row[0]);
ret->zfinId = cloneString(row[1]);
ret->uniProtId = cloneString(row[2]);
ret->spDisplayId = cloneString(row[3]);
ret->geneId = cloneString(row[4]);
ret->geneSymbol = cloneString(row[5]);
ret->refSeq = cloneString(row[6]);
ret->protAcc = cloneString(row[7]);
ret->description = cloneString(row[8]);
return ret;
}

struct ensXRefZfish *ensXRefZfishLoadAll(char *fileName) 
/* Load all ensXRefZfish from a whitespace-separated file.
 * Dispose of this with ensXRefZfishFreeList(). */
{
struct ensXRefZfish *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = ensXRefZfishLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ensXRefZfish *ensXRefZfishLoadAllByChar(char *fileName, char chopper) 
/* Load all ensXRefZfish from a chopper separated file.
 * Dispose of this with ensXRefZfishFreeList(). */
{
struct ensXRefZfish *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = ensXRefZfishLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ensXRefZfish *ensXRefZfishCommaIn(char **pS, struct ensXRefZfish *ret)
/* Create a ensXRefZfish out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ensXRefZfish */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->ensGeneId = sqlStringComma(&s);
ret->zfinId = sqlStringComma(&s);
ret->uniProtId = sqlStringComma(&s);
ret->spDisplayId = sqlStringComma(&s);
ret->geneId = sqlStringComma(&s);
ret->geneSymbol = sqlStringComma(&s);
ret->refSeq = sqlStringComma(&s);
ret->protAcc = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void ensXRefZfishFree(struct ensXRefZfish **pEl)
/* Free a single dynamically allocated ensXRefZfish such as created
 * with ensXRefZfishLoad(). */
{
struct ensXRefZfish *el;

if ((el = *pEl) == NULL) return;
freeMem(el->ensGeneId);
freeMem(el->zfinId);
freeMem(el->uniProtId);
freeMem(el->spDisplayId);
freeMem(el->geneId);
freeMem(el->geneSymbol);
freeMem(el->refSeq);
freeMem(el->protAcc);
freeMem(el->description);
freez(pEl);
}

void ensXRefZfishFreeList(struct ensXRefZfish **pList)
/* Free a list of dynamically allocated ensXRefZfish's */
{
struct ensXRefZfish *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    ensXRefZfishFree(&el);
    }
*pList = NULL;
}

void ensXRefZfishOutput(struct ensXRefZfish *el, FILE *f, char sep, char lastSep) 
/* Print out ensXRefZfish.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ensGeneId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->zfinId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->uniProtId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->spDisplayId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneSymbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->refSeq);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->protAcc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

