# gtexGeneBed.sql was originally generated by the autoSql program, which also 
# generated gtexGeneBed.c and gtexGeneBed.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#BED6+ with additional fields for gene and transcript IDs, and expression experiment scores
CREATE TABLE gtexGeneBed (
    chrom varchar(255) not null,	# Reference sequence chromosome or scaffold
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# Gene symbol
    score int unsigned not null,	# Score from 0-1000
    strand char(1) not null,	# + or - for strand
    geneId varchar(255) not null,	# Ensembl gene ID, referenced in GTEx data tables
    geneType varchar(255) not null,	# GENCODE gene biotype
    expCount int unsigned not null,	# Number of experiment values
    expScores longblob not null,	# Comma separated list of experiment scores
              #Indices
    PRIMARY KEY(chrom,geneId),
    INDEX(geneId),
    INDEX(chrom(20), chromStart)
);
