/* mysqlTableStatus.c was originally generated by the autoSql program, which also 
 * generated mysqlTableStatus.h and mysqlTableStatus.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "mysqlTableStatus.h"


void mysqlTableStatusStaticLoad(char **row, struct mysqlTableStatus *ret)
/* Load a row from mysqlTableStatus table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->type = row[1];
ret->rowFormat = row[2];
ret->rowCount = sqlSigned(row[3]);
ret->averageRowLength = sqlSigned(row[4]);
ret->dataLength = sqlSigned(row[5]);
ret->maxDataLength = sqlSigned(row[6]);
ret->indexLength = sqlSigned(row[7]);
ret->dataFree = sqlSigned(row[8]);
ret->autoIncrement = row[9];
ret->createTime = row[10];
ret->updateTime = row[11];
ret->checkTime = row[12];
}

struct mysqlTableStatus *mysqlTableStatusLoad(char **row)
/* Load a mysqlTableStatus from row fetched with select * from mysqlTableStatus
 * from database.  Dispose of this with mysqlTableStatusFree(). */
{
struct mysqlTableStatus *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->type = cloneString(row[1]);
ret->rowFormat = cloneString(row[2]);
ret->rowCount = sqlSigned(row[3]);
ret->averageRowLength = sqlSigned(row[4]);
ret->dataLength = sqlSigned(row[5]);
ret->maxDataLength = sqlSigned(row[6]);
ret->indexLength = sqlSigned(row[7]);
ret->dataFree = sqlSigned(row[8]);
ret->autoIncrement = cloneString(row[9]);
ret->createTime = cloneString(row[10]);
ret->updateTime = cloneString(row[11]);
ret->checkTime = cloneString(row[12]);
return ret;
}

void mysqlTableStatusFree(struct mysqlTableStatus **pEl)
/* Free a single dynamically allocated mysqlTableStatus such as created
 * with mysqlTableStatusLoad(). */
{
struct mysqlTableStatus *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->type);
freeMem(el->rowFormat);
freeMem(el->autoIncrement);
freeMem(el->createTime);
freeMem(el->updateTime);
freeMem(el->checkTime);
freez(pEl);
}

void mysqlTableStatusFreeList(struct mysqlTableStatus **pList)
/* Free a list of dynamically allocated mysqlTableStatus's */
{
struct mysqlTableStatus *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    mysqlTableStatusFree(&el);
    }
*pList = NULL;
}

void mysqlTableStatusOutput(struct mysqlTableStatus *el, FILE *f, char sep, char lastSep) 
/* Print out mysqlTableStatus.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rowFormat);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->rowCount);
fputc(sep,f);
fprintf(f, "%d", el->averageRowLength);
fputc(sep,f);
fprintf(f, "%d", el->dataLength);
fputc(sep,f);
fprintf(f, "%d", el->maxDataLength);
fputc(sep,f);
fprintf(f, "%d", el->indexLength);
fputc(sep,f);
fprintf(f, "%d", el->dataFree);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->autoIncrement);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->createTime);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->updateTime);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->checkTime);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

