/* ncbiRefLink.c was originally generated by the autoSql program, which also 
 * generated ncbiRefLink.h and ncbiRefLink.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "ncbiRefLink.h"



char *ncbiRefLinkCommaSepFieldNames = "id,gbKey,gene,dbXref,product";

void ncbiRefLinkStaticLoad(char **row, struct ncbiRefLink *ret)
/* Load a row from ncbiRefLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = row[0];
ret->gbKey = row[1];
ret->gene = row[2];
ret->dbXref = row[3];
ret->product = row[4];
}

struct ncbiRefLink *ncbiRefLinkLoad(char **row)
/* Load a ncbiRefLink from row fetched with select * from ncbiRefLink
 * from database.  Dispose of this with ncbiRefLinkFree(). */
{
struct ncbiRefLink *ret;

AllocVar(ret);
ret->id = cloneString(row[0]);
ret->gbKey = cloneString(row[1]);
ret->gene = cloneString(row[2]);
ret->dbXref = cloneString(row[3]);
ret->product = cloneString(row[4]);
return ret;
}

struct ncbiRefLink *ncbiRefLinkLoadAll(char *fileName) 
/* Load all ncbiRefLink from a whitespace-separated file.
 * Dispose of this with ncbiRefLinkFreeList(). */
{
struct ncbiRefLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = ncbiRefLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ncbiRefLink *ncbiRefLinkLoadAllByChar(char *fileName, char chopper) 
/* Load all ncbiRefLink from a chopper separated file.
 * Dispose of this with ncbiRefLinkFreeList(). */
{
struct ncbiRefLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = ncbiRefLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ncbiRefLink *ncbiRefLinkCommaIn(char **pS, struct ncbiRefLink *ret)
/* Create a ncbiRefLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ncbiRefLink */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlStringComma(&s);
ret->gbKey = sqlStringComma(&s);
ret->gene = sqlStringComma(&s);
ret->dbXref = sqlStringComma(&s);
ret->product = sqlStringComma(&s);
*pS = s;
return ret;
}

void ncbiRefLinkFree(struct ncbiRefLink **pEl)
/* Free a single dynamically allocated ncbiRefLink such as created
 * with ncbiRefLinkLoad(). */
{
struct ncbiRefLink *el;

if ((el = *pEl) == NULL) return;
freeMem(el->id);
freeMem(el->gbKey);
freeMem(el->gene);
freeMem(el->dbXref);
freeMem(el->product);
freez(pEl);
}

void ncbiRefLinkFreeList(struct ncbiRefLink **pList)
/* Free a list of dynamically allocated ncbiRefLink's */
{
struct ncbiRefLink *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    ncbiRefLinkFree(&el);
    }
*pList = NULL;
}

void ncbiRefLinkOutput(struct ncbiRefLink *el, FILE *f, char sep, char lastSep) 
/* Print out ncbiRefLink.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->id);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gbKey);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gene);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dbXref);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->product);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

