/* stsAlias.c was originally generated by the autoSql program, which also 
 * generated stsAlias.h and stsAlias.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "jksql.h"
#include "stsAlias.h"


void stsAliasStaticLoad(char **row, struct stsAlias *ret)
/* Load a row from stsAlias table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->alias = row[0];
ret->identNo = sqlUnsigned(row[1]);
ret->trueName = row[2];
}

struct stsAlias *stsAliasLoad(char **row)
/* Load a stsAlias from row fetched with select * from stsAlias
 * from database.  Dispose of this with stsAliasFree(). */
{
struct stsAlias *ret;

AllocVar(ret);
ret->alias = cloneString(row[0]);
ret->identNo = sqlUnsigned(row[1]);
ret->trueName = cloneString(row[2]);
return ret;
}

struct stsAlias *stsAliasLoadAll(char *fileName) 
/* Load all stsAlias from a tab-separated file.
 * Dispose of this with stsAliasFreeList(). */
{
struct stsAlias *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = stsAliasLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct stsAlias *stsAliasCommaIn(char **pS, struct stsAlias *ret)
/* Create a stsAlias out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new stsAlias */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->alias = sqlStringComma(&s);
ret->identNo = sqlUnsignedComma(&s);
ret->trueName = sqlStringComma(&s);
*pS = s;
return ret;
}

void stsAliasFree(struct stsAlias **pEl)
/* Free a single dynamically allocated stsAlias such as created
 * with stsAliasLoad(). */
{
struct stsAlias *el;

if ((el = *pEl) == NULL) return;
freeMem(el->alias);
freeMem(el->trueName);
freez(pEl);
}

void stsAliasFreeList(struct stsAlias **pList)
/* Free a list of dynamically allocated stsAlias's */
{
struct stsAlias *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    stsAliasFree(&el);
    }
*pList = NULL;
}

void stsAliasOutput(struct stsAlias *el, FILE *f, char sep, char lastSep) 
/* Print out stsAlias.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->alias);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->identNo);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->trueName);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

