table bed12BgpUniProtAnnot
"Browser extensible data (12 fields), eight fields for bigGenePred support, plus extra fields (dbName-pmids, not used by all UniProt subtracks) with UniProt-specific information"
    (
    string chrom;      "Chromosome (or contig, scaffold, etc.)"
    uint   chromStart; "Start position in chromosome"
    uint   chromEnd;   "End position in chromosome"
    string name;       "Name of item"
    uint   score;      "Score from 0-1000"
    char[1] strand;    "+ or -"
    uint thickStart;   "Start of where display should be thick (start codon)"
    uint thickEnd;     "End of where display should be thick (stop codon)"
    uint reserved;     "Used as itemRgb as of 2004-11-22"
    int blockCount;    "Number of blocks"
    int[blockCount] blockSizes; "Comma separated list of block sizes"
    int[blockCount] chromStarts; "Start positions relative to chromStart"

    string name2;               "Alternative/human readable name"
    string cdsStartStat;        "Status of CDS start annotation (none, unknown, incomplete, or complete)"
    string cdsEndStat;          "Status of CDS end annotation (none, unknown, incomplete, or complete)"
    int[blockCount] exonFrames; "Exon frame {0,1,2}, or -1 if no frame for exon"
    string type;                "Transcript type"
    string geneName;            "Primary identifier for gene"
    string geneName2;           "Alternative/human-readable gene name"
    string geneType;            "Gene type"

    string acc; "UniProt main accession"
    lstring uniprotName; "UniProt main record name"
    string status; "UniProt status"
    lstring accList; "UniProt all accessions"
    lstring isoIds; "UniProt isoform accessions"

    lstring protFullNames; "UniProt protein name"
    lstring protShortNames; "UniProt protein short name"
    lstring protAltFullNames; "UniProt alternative names"
    lstring protAltShortNames; "UniProt alternative short names"
    lstring geneNameDupl; "UniProt gene name"
    lstring geneSynonyms; "UniProt gene synonyms"
    lstring functionText; "UniProt function"

    lstring hgncSym; "HGNC Gene Symbol"
    lstring hgncId; "HGNC ID"
    lstring refSeq; "RefSeq IDs"
    lstring refSeqProt; "RefSeq Protein IDs"
    lstring entrezGene; "NCBI Entrez Gene"
    lstring ensGene; "Ensembl Gene IDs"
    lstring ensProt; "Ensembl Protein IDs"
    lstring ensTrans; "Ensembl Transcript IDs"
    )
