/* binTest.c was originally generated by the autoSql program, which also 
 * generated binTest.h and binTest.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "output/binTest.h"


void nonGenomicStaticLoad(char **row, struct nonGenomic *ret)
/* Load a row from nonGenomic table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->key = sqlUnsigned(row[0]);
ret->name = row[1];
ret->address = row[2];
}

struct nonGenomic *nonGenomicLoad(char **row)
/* Load a nonGenomic from row fetched with select * from nonGenomic
 * from database.  Dispose of this with nonGenomicFree(). */
{
struct nonGenomic *ret;

AllocVar(ret);
ret->key = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->address = cloneString(row[2]);
return ret;
}

struct nonGenomic *nonGenomicLoadAll(char *fileName) 
/* Load all nonGenomic from a whitespace-separated file.
 * Dispose of this with nonGenomicFreeList(). */
{
struct nonGenomic *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = nonGenomicLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct nonGenomic *nonGenomicLoadAllByChar(char *fileName, char chopper) 
/* Load all nonGenomic from a chopper separated file.
 * Dispose of this with nonGenomicFreeList(). */
{
struct nonGenomic *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = nonGenomicLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct nonGenomic *nonGenomicCommaIn(char **pS, struct nonGenomic *ret)
/* Create a nonGenomic out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new nonGenomic */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->key = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->address = sqlStringComma(&s);
*pS = s;
return ret;
}

void nonGenomicFree(struct nonGenomic **pEl)
/* Free a single dynamically allocated nonGenomic such as created
 * with nonGenomicLoad(). */
{
struct nonGenomic *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->address);
freez(pEl);
}

void nonGenomicFreeList(struct nonGenomic **pList)
/* Free a list of dynamically allocated nonGenomic's */
{
struct nonGenomic *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    nonGenomicFree(&el);
    }
*pList = NULL;
}

void nonGenomicOutput(struct nonGenomic *el, FILE *f, char sep, char lastSep) 
/* Print out nonGenomic.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->key);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->address);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void alreadyBinnedStaticLoad(char **row, struct alreadyBinned *ret)
/* Load a row from alreadyBinned table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->bin = sqlUnsigned(row[0]);
ret->chrom = row[1];
ret->start = sqlSigned(row[2]);
ret->end = sqlSigned(row[3]);
ret->name = row[4];
ret->id = sqlUnsigned(row[5]);
}

struct alreadyBinned *alreadyBinnedLoad(char **row)
/* Load a alreadyBinned from row fetched with select * from alreadyBinned
 * from database.  Dispose of this with alreadyBinnedFree(). */
{
struct alreadyBinned *ret;

AllocVar(ret);
ret->bin = sqlUnsigned(row[0]);
ret->chrom = cloneString(row[1]);
ret->start = sqlSigned(row[2]);
ret->end = sqlSigned(row[3]);
ret->name = cloneString(row[4]);
ret->id = sqlUnsigned(row[5]);
return ret;
}

struct alreadyBinned *alreadyBinnedLoadAll(char *fileName) 
/* Load all alreadyBinned from a whitespace-separated file.
 * Dispose of this with alreadyBinnedFreeList(). */
{
struct alreadyBinned *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = alreadyBinnedLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct alreadyBinned *alreadyBinnedLoadAllByChar(char *fileName, char chopper) 
/* Load all alreadyBinned from a chopper separated file.
 * Dispose of this with alreadyBinnedFreeList(). */
{
struct alreadyBinned *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = alreadyBinnedLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct alreadyBinned *alreadyBinnedCommaIn(char **pS, struct alreadyBinned *ret)
/* Create a alreadyBinned out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new alreadyBinned */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->bin = sqlUnsignedComma(&s);
ret->chrom = sqlStringComma(&s);
ret->start = sqlSignedComma(&s);
ret->end = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->id = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void alreadyBinnedFree(struct alreadyBinned **pEl)
/* Free a single dynamically allocated alreadyBinned such as created
 * with alreadyBinnedLoad(). */
{
struct alreadyBinned *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void alreadyBinnedFreeList(struct alreadyBinned **pList)
/* Free a list of dynamically allocated alreadyBinned's */
{
struct alreadyBinned *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    alreadyBinnedFree(&el);
    }
*pList = NULL;
}

void alreadyBinnedOutput(struct alreadyBinned *el, FILE *f, char sep, char lastSep) 
/* Print out alreadyBinned.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->bin);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->start);
fputc(sep,f);
fprintf(f, "%d", el->end);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->id);
fputc(lastSep,f);
}

void needBinStaticLoad(char **row, struct needBin *ret)
/* Load a row from needBin table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->bin = sqlUnsigned(row[0]);
ret->chrom = row[1];
ret->start = sqlSigned(row[2]);
ret->end = sqlSigned(row[3]);
ret->name = row[4];
ret->id = sqlUnsigned(row[5]);
}

struct needBin *needBinLoad(char **row)
/* Load a needBin from row fetched with select * from needBin
 * from database.  Dispose of this with needBinFree(). */
{
struct needBin *ret;

AllocVar(ret);
ret->bin = sqlUnsigned(row[0]);
ret->chrom = cloneString(row[1]);
ret->start = sqlSigned(row[2]);
ret->end = sqlSigned(row[3]);
ret->name = cloneString(row[4]);
ret->id = sqlUnsigned(row[5]);
return ret;
}

struct needBin *needBinLoadAll(char *fileName) 
/* Load all needBin from a whitespace-separated file.
 * Dispose of this with needBinFreeList(). */
{
struct needBin *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = needBinLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct needBin *needBinLoadAllByChar(char *fileName, char chopper) 
/* Load all needBin from a chopper separated file.
 * Dispose of this with needBinFreeList(). */
{
struct needBin *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = needBinLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct needBin *needBinCommaIn(char **pS, struct needBin *ret)
/* Create a needBin out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new needBin */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->bin = sqlUnsignedComma(&s);
ret->chrom = sqlStringComma(&s);
ret->start = sqlSignedComma(&s);
ret->end = sqlSignedComma(&s);
ret->name = sqlStringComma(&s);
ret->id = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void needBinFree(struct needBin **pEl)
/* Free a single dynamically allocated needBin such as created
 * with needBinLoad(). */
{
struct needBin *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void needBinFreeList(struct needBin **pList)
/* Free a list of dynamically allocated needBin's */
{
struct needBin *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    needBinFree(&el);
    }
*pList = NULL;
}

void needBinOutput(struct needBin *el, FILE *f, char sep, char lastSep) 
/* Print out needBin.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->bin);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->start);
fputc(sep,f);
fprintf(f, "%d", el->end);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->id);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

