/* atomDb.c was originally generated by the autoSql program, which also 
 * generated atomDb.h and atomDb.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "atomDb.h"


void atomStaticLoad(char **row, struct atom *ret)
/* Load a row from atom table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->instance = sqlUnsigned(row[1]);
ret->species = row[2];
ret->chrom = row[3];
ret->start = sqlUnsigned(row[4]);
ret->end = sqlUnsigned(row[5]);
safecpy(ret->strand, sizeof(ret->strand), row[6]);
ret->fivePrime = row[7];
ret->threePrime = row[8];
}

struct atom *atomLoad(char **row)
/* Load a atom from row fetched with select * from atom
 * from database.  Dispose of this with atomFree(). */
{
struct atom *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->instance = sqlUnsigned(row[1]);
ret->species = cloneString(row[2]);
ret->chrom = cloneString(row[3]);
ret->start = sqlUnsigned(row[4]);
ret->end = sqlUnsigned(row[5]);
safecpy(ret->strand, sizeof(ret->strand), row[6]);
ret->fivePrime = cloneString(row[7]);
ret->threePrime = cloneString(row[8]);
return ret;
}

struct atom *atomLoadAll(char *fileName) 
/* Load all atom from a whitespace-separated file.
 * Dispose of this with atomFreeList(). */
{
struct atom *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = atomLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct atom *atomLoadAllByChar(char *fileName, char chopper) 
/* Load all atom from a chopper separated file.
 * Dispose of this with atomFreeList(). */
{
struct atom *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = atomLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct atom *atomCommaIn(char **pS, struct atom *ret)
/* Create a atom out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new atom */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->instance = sqlUnsignedComma(&s);
ret->species = sqlStringComma(&s);
ret->chrom = sqlStringComma(&s);
ret->start = sqlUnsignedComma(&s);
ret->end = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->fivePrime = sqlStringComma(&s);
ret->threePrime = sqlStringComma(&s);
*pS = s;
return ret;
}

void atomFree(struct atom **pEl)
/* Free a single dynamically allocated atom such as created
 * with atomLoad(). */
{
struct atom *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->species);
freeMem(el->chrom);
freeMem(el->fivePrime);
freeMem(el->threePrime);
freez(pEl);
}

void atomFreeList(struct atom **pList)
/* Free a list of dynamically allocated atom's */
{
struct atom *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    atomFree(&el);
    }
*pList = NULL;
}

void atomOutput(struct atom *el, FILE *f, char sep, char lastSep) 
/* Print out atom.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->instance);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->species);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->start);
fputc(sep,f);
fprintf(f, "%u", el->end);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fivePrime);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->threePrime);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

