/* gencodeToUniProt.c was originally generated by the autoSql program, which also 
 * generated gencodeToUniProt.h and gencodeToUniProt.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gencodeToUniProt.h"



char *gencodeToUniProtCommaSepFieldNames = "transcriptId,acc,name,dataset";

/* definitions for dataset column */
static char *values_dataset[] = {"SwissProt", "TrEMBL", NULL};
static struct hash *valhash_dataset = NULL;

void gencodeToUniProtStaticLoad(char **row, struct gencodeToUniProt *ret)
/* Load a row from gencodeToUniProt table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->transcriptId = row[0];
ret->acc = row[1];
ret->name = row[2];
ret->dataset = sqlEnumParse(row[3], values_dataset, &valhash_dataset);
}

struct gencodeToUniProt *gencodeToUniProtLoad(char **row)
/* Load a gencodeToUniProt from row fetched with select * from gencodeToUniProt
 * from database.  Dispose of this with gencodeToUniProtFree(). */
{
struct gencodeToUniProt *ret;

AllocVar(ret);
ret->transcriptId = cloneString(row[0]);
ret->acc = cloneString(row[1]);
ret->name = cloneString(row[2]);
ret->dataset = sqlEnumParse(row[3], values_dataset, &valhash_dataset);
return ret;
}

struct gencodeToUniProt *gencodeToUniProtLoadAll(char *fileName) 
/* Load all gencodeToUniProt from a whitespace-separated file.
 * Dispose of this with gencodeToUniProtFreeList(). */
{
struct gencodeToUniProt *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = gencodeToUniProtLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gencodeToUniProt *gencodeToUniProtLoadAllByChar(char *fileName, char chopper) 
/* Load all gencodeToUniProt from a chopper separated file.
 * Dispose of this with gencodeToUniProtFreeList(). */
{
struct gencodeToUniProt *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gencodeToUniProtLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gencodeToUniProt *gencodeToUniProtCommaIn(char **pS, struct gencodeToUniProt *ret)
/* Create a gencodeToUniProt out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gencodeToUniProt */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->transcriptId = sqlStringComma(&s);
ret->acc = sqlStringComma(&s);
ret->name = sqlStringComma(&s);
ret->dataset = sqlEnumComma(&s, values_dataset, &valhash_dataset);
*pS = s;
return ret;
}

void gencodeToUniProtFree(struct gencodeToUniProt **pEl)
/* Free a single dynamically allocated gencodeToUniProt such as created
 * with gencodeToUniProtLoad(). */
{
struct gencodeToUniProt *el;

if ((el = *pEl) == NULL) return;
freeMem(el->transcriptId);
freeMem(el->acc);
freeMem(el->name);
freez(pEl);
}

void gencodeToUniProtFreeList(struct gencodeToUniProt **pList)
/* Free a list of dynamically allocated gencodeToUniProt's */
{
struct gencodeToUniProt *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gencodeToUniProtFree(&el);
    }
*pList = NULL;
}

void gencodeToUniProtOutput(struct gencodeToUniProt *el, FILE *f, char sep, char lastSep) 
/* Print out gencodeToUniProt.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->transcriptId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
sqlEnumPrint(f, el->dataset, values_dataset);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

