/* atomDb.h was originally generated by the autoSql program, which also 
 * generated atomDb.c and atomDb.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ATOMDB_H
#define ATOMDB_H

#define ATOM_NUM_COLS 9

struct atom
/* Table of atoms in more than one species */
    {
    struct atom *next;  /* Next in singly linked list. */
    char *name;	/* atom name */
    unsigned instance;	/* instance number */
    char *species;	/* species name */
    char *chrom;	/* chromosome */
    unsigned start;	/* chrom start */
    unsigned end;	/* chrom end */
    char strand[2];	/* + or - */
    char *fivePrime;	/* atom on the 5' end */
    char *threePrime;	/* atom on the 3' end */
    };

void atomStaticLoad(char **row, struct atom *ret);
/* Load a row from atom table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct atom *atomLoad(char **row);
/* Load a atom from row fetched with select * from atom
 * from database.  Dispose of this with atomFree(). */

struct atom *atomLoadAll(char *fileName);
/* Load all atom from whitespace-separated file.
 * Dispose of this with atomFreeList(). */

struct atom *atomLoadAllByChar(char *fileName, char chopper);
/* Load all atom from chopper separated file.
 * Dispose of this with atomFreeList(). */

#define atomLoadAllByTab(a) atomLoadAllByChar(a, '\t');
/* Load all atom from tab separated file.
 * Dispose of this with atomFreeList(). */

struct atom *atomCommaIn(char **pS, struct atom *ret);
/* Create a atom out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new atom */

void atomFree(struct atom **pEl);
/* Free a single dynamically allocated atom such as created
 * with atomLoad(). */

void atomFreeList(struct atom **pList);
/* Free a list of dynamically allocated atom's */

void atomOutput(struct atom *el, FILE *f, char sep, char lastSep);
/* Print out atom.  Separate fields with sep. Follow last field with lastSep. */

#define atomTabOut(el,f) atomOutput(el,f,'\t','\n');
/* Print out atom as a line in a tab-separated file. */

#define atomCommaOut(el,f) atomOutput(el,f,',',',');
/* Print out atom as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ATOMDB_H */

