/* barChartBed.h was originally generated by the autoSql program, which also 
 * generated barChartBed.c and barChartBed.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BARCHARTBED_H
#define BARCHARTBED_H

#include "jksql.h"
#define BARCHARTBED_NUM_COLS 11

extern char *barChartBedCommaSepFieldNames;

struct barChartBed
/* BED6+5 with additional fields for category count and median values, and sample matrix fields */
    {
    struct barChartBed *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name or ID of item, ideally both human readable and unique */
    unsigned score;	/* Score from 0-1000, typically derived from total of median value from all categories */
    char strand[2];	/* + or - for strand. Use . if not applicable */
    char *name2;	/* Alternative name for item */
    unsigned expCount;	/* Number of categories */
    float *expScores;	/* Comma separated list of category values */
    long long _dataOffset;	/* Offset of sample data in data matrix file, for boxplot on details page */
    int _dataLen;	/* Length of sample data row in data matrix file */
    };

struct barChartBed *barChartBedLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all barChartBed from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with barChartBedFreeList(). */

void barChartBedSaveToDb(struct sqlConnection *conn, struct barChartBed *el, char *tableName, int updateSize);
/* Save barChartBed as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct barChartBed *barChartBedLoad(char **row);
/* Load a barChartBed from row fetched with select * from barChartBed
 * from database.  Dispose of this with barChartBedFree(). */

struct barChartBed *barChartBedLoadAll(char *fileName);
/* Load all barChartBed from whitespace-separated file.
 * Dispose of this with barChartBedFreeList(). */

struct barChartBed *barChartBedLoadAllByChar(char *fileName, char chopper);
/* Load all barChartBed from chopper separated file.
 * Dispose of this with barChartBedFreeList(). */

#define barChartBedLoadAllByTab(a) barChartBedLoadAllByChar(a, '\t');
/* Load all barChartBed from tab separated file.
 * Dispose of this with barChartBedFreeList(). */

struct barChartBed *barChartBedCommaIn(char **pS, struct barChartBed *ret);
/* Create a barChartBed out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new barChartBed */

void barChartBedFree(struct barChartBed **pEl);
/* Free a single dynamically allocated barChartBed such as created
 * with barChartBedLoad(). */

void barChartBedFreeList(struct barChartBed **pList);
/* Free a list of dynamically allocated barChartBed's */

void barChartBedOutput(struct barChartBed *el, FILE *f, char sep, char lastSep);
/* Print out barChartBed.  Separate fields with sep. Follow last field with lastSep. */

#define barChartBedTabOut(el,f) barChartBedOutput(el,f,'\t','\n');
/* Print out barChartBed as a line in a tab-separated file. */

#define barChartBedCommaOut(el,f) barChartBedOutput(el,f,',',',');
/* Print out barChartBed as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#include "basicBed.h"

#define BARCHART_OFFSET_COLUMN "_dataOffset"
#define BARCHART_LEN_COLUMN "_dataLen"

// indexes in .as file for standard barChartBed.  Use to find comparable fields in custom .as's
#define BARCHART_NAME_COLUMN_IX         3
#define BARCHART_NAME2_COLUMN_IX        6
#define BARCHART_EXPCOUNT_COLUMN_IX     7
#define BARCHART_EXPSCORES_COLUMN_IX    8 

void barChartBedCreateTable(struct sqlConnection *conn, char *table);
/* Create barChart format table of given name. */

struct asObject *barChartAsObj();
/* Return asObject describing fields of barChart database table (includes bin) */

struct bed *barChartSimpleBedLoad(char **row);
/* Load a bed from row containing barChart bed fields. 
 * This is reuses autoSql barChartBedLoad, but with a full-size bed.
 Dispose of this with bedFree() */

struct barChartBed *barChartBedLoadOptionalOffsets(char **row, boolean hasOffsets);
/* TODO: remove this -- offsets field will be required (though may be 0) */
/* Load a barChartBed from row fetched with select * from barChartBed
 * from database or file.  Also supports schema lacking file offet and length for details.
.  Dispose of this with barChartBedFree(). */

float barChartTotalValue(struct barChartBed *bed);
/* Return total of all category values */

float barChartMaxValue(struct barChartBed *bed, int *categIdRet);
/* Return value and id of category with highest value for this item */

#endif /* BARCHARTBED_H */

