/* bigPsl.h was originally generated by the autoSql program, which also 
 * generated bigPsl.c and bigPsl.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BIGPSL_H
#define BIGPSL_H

#include "bigBed.h"
#include "dnaseq.h"

#define BIGPSL_NUM_COLS 24

extern char *bigPslCommaSepFieldNames;

#define PSL_SEQTYPE_EMPTY               0
#define PSL_SEQTYPE_NUCLEOTIDE          1
#define PSL_SEQTYPE_PROTEIN             2

struct bigPsl
/* bigPsl pairwise alignment */
    {
    struct bigPsl *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name or ID of item, ideally both human readable and unique */
    unsigned score;	/* Score (0-1000) */
    char strand[2];	/* + or - indicates whether the query aligns to the + or - strand on the reference */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* RGB value (use R,G,B string in input file) */
    int blockCount;	/* Number of blocks */
    int *blockSizes;	/* Comma separated list of block sizes */
    int *chromStarts;	/* Start positions relative to chromStart */
    unsigned oChromStart;	/* Start position in other chromosome */
    unsigned oChromEnd;	/* End position in other chromosome */
    char oStrand[2];	/* + or -, - implies doing a reverse complement on the psl on output */
    unsigned oChromSize;	/* Size of other chromosome. */
    int *oChromStarts;	/* Start positions relative to oChromStart or from oChromStart+oChromSize depending on strand */
    char *oSequence;	/* Sequence on other chrom (or edit list, or empty) */
    char *oCDS;	/* CDS in NCBI format */
    unsigned chromSize;	/* Size of target chromosome */
    unsigned match;	/* Number of bases matched. */
    unsigned misMatch;	/*  Number of bases that don't match  */
    unsigned repMatch;	/*  Number of bases that match but are part of repeats  */
    unsigned nCount;	/*  Number of 'N' bases  */
    unsigned seqType;   /* type of sequence in oSequence */
    };

struct bigPsl *bigPslLoad(char **row);
/* Load a bigPsl from row fetched with select * from bigPsl
 * from database.  Dispose of this with bigPslFree(). */

struct bigPsl *bigPslLoadAll(char *fileName);
/* Load all bigPsl from whitespace-separated file.
 * Dispose of this with bigPslFreeList(). */

struct bigPsl *bigPslLoadAllByChar(char *fileName, char chopper);
/* Load all bigPsl from chopper separated file.
 * Dispose of this with bigPslFreeList(). */

#define bigPslLoadAllByTab(a) bigPslLoadAllByChar(a, '\t');
/* Load all bigPsl from tab separated file.
 * Dispose of this with bigPslFreeList(). */

struct bigPsl *bigPslCommaIn(char **pS, struct bigPsl *ret);
/* Create a bigPsl out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bigPsl */

void bigPslFree(struct bigPsl **pEl);
/* Free a single dynamically allocated bigPsl such as created
 * with bigPslLoad(). */

void bigPslFreeList(struct bigPsl **pList);
/* Free a list of dynamically allocated bigPsl's */

void bigPslOutput(struct bigPsl *el, FILE *f, char sep, char lastSep);
/* Print out bigPsl.  Separate fields with sep. Follow last field with lastSep. */

#define bigPslTabOut(el,f) bigPslOutput(el,f,'\t','\n');
/* Print out bigPsl as a line in a tab-separated file. */

#define bigPslCommaOut(el,f) bigPslOutput(el,f,',',',');
/* Print out bigPsl as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct psl  *pslFromBigPsl( char *chrom, struct bigBedInterval *bb,  int seqTypeField, char **seq, char **cds);
/* build a psl from a bigPsl */
#endif /* BIGPSL_H */
