/* geneCheckDetails.h was originally generated by the autoSql program, which also 
 * generated geneCheckDetails.c and geneCheckDetails.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2006 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef GENECHECKDETAILS_H
#define GENECHECKDETAILS_H

#define GENECHECKDETAILS_NUM_COLS 6

struct geneCheckDetails
/* details from gene-check program */
    {
    struct geneCheckDetails *next;  /* Next in singly linked list. */
    char *acc;	/* gene id or accession */
    char *problem;	/* problem */
    char *info;	/* additional information  */
    char *chr;	/* chromosome */
    unsigned chrStart;	/* chromosome start */
    unsigned chrEnd;	/* chromosome end */
    };

void geneCheckDetailsStaticLoad(char **row, struct geneCheckDetails *ret);
/* Load a row from geneCheckDetails table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct geneCheckDetails *geneCheckDetailsLoad(char **row);
/* Load a geneCheckDetails from row fetched with select * from geneCheckDetails
 * from database.  Dispose of this with geneCheckDetailsFree(). */

struct geneCheckDetails *geneCheckDetailsLoadAll(char *fileName);
/* Load all geneCheckDetails from whitespace-separated file.
 * Dispose of this with geneCheckDetailsFreeList(). */

struct geneCheckDetails *geneCheckDetailsLoadAllByChar(char *fileName, char chopper);
/* Load all geneCheckDetails from chopper separated file.
 * Dispose of this with geneCheckDetailsFreeList(). */

#define geneCheckDetailsLoadAllByTab(a) geneCheckDetailsLoadAllByChar(a, '\t');
/* Load all geneCheckDetails from tab separated file.
 * Dispose of this with geneCheckDetailsFreeList(). */

struct geneCheckDetails *geneCheckDetailsCommaIn(char **pS, struct geneCheckDetails *ret);
/* Create a geneCheckDetails out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new geneCheckDetails */

void geneCheckDetailsFree(struct geneCheckDetails **pEl);
/* Free a single dynamically allocated geneCheckDetails such as created
 * with geneCheckDetailsLoad(). */

void geneCheckDetailsFreeList(struct geneCheckDetails **pList);
/* Free a list of dynamically allocated geneCheckDetails's */

void geneCheckDetailsOutput(struct geneCheckDetails *el, FILE *f, char sep, char lastSep);
/* Print out geneCheckDetails.  Separate fields with sep. Follow last field with lastSep. */

#define geneCheckDetailsTabOut(el,f) geneCheckDetailsOutput(el,f,'\t','\n');
/* Print out geneCheckDetails as a line in a tab-separated file. */

#define geneCheckDetailsCommaOut(el,f) geneCheckDetailsOutput(el,f,',',',');
/* Print out geneCheckDetails as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* GENECHECKDETAILS_H */

