/* hapmapPrimateAlleles.h was originally generated by the autoSql program, which also 
 * generated hapmapPrimateAlleles.c and hapmapPrimateAlleles.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef HAPMAPPRIMATEALLELES_H
#define HAPMAPPRIMATEALLELES_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define HAPMAPPRIMATEALLELES_NUM_COLS 18

struct hapmapPrimateAlleles
/* Primate (chimp and macaque) alleles for HapMap SNPs */
    {
    struct hapmapPrimateAlleles *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* Name of SNP - rsId or temporary name */
    unsigned score;	/* 0 */
    char strand;	/* + or - */
    char refAllele;	/* A, C, G, or T */
    char otherAllele;	/* A, C, G, or T */
    char *chimpChrom;	/* Chimp Chromosome */
    unsigned chimpPos;	/* End position in himpChrom */
    char chimpStrand;	/* + or - or . */
    char *chimpAllele;	/* A, C, G, T, a, c, g, t, or . */
    unsigned chimpQual;	/* Chimp quality score */
    char *rhesusChrom;	/* Rhesus Chromosome */
    unsigned rhesusPos;	/* End position in rhesusChrom */
    char rhesusStrand;	/* + or - or . */
    char *rhesusAllele;	/* A, C, G, T, a, c, g, t, or . */
    unsigned rhesusQual;	/* Rhesus quality score */
    };

void hapmapPrimateAllelesStaticLoad(char **row, struct hapmapPrimateAlleles *ret);
/* Load a row from hapmapPrimateAlleles table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct hapmapPrimateAlleles *hapmapPrimateAllelesLoad(char **row);
/* Load a hapmapPrimateAlleles from row fetched with select * from hapmapPrimateAlleles
 * from database.  Dispose of this with hapmapPrimateAllelesFree(). */

struct hapmapPrimateAlleles *hapmapPrimateAllelesLoadAll(char *fileName);
/* Load all hapmapPrimateAlleles from whitespace-separated file.
 * Dispose of this with hapmapPrimateAllelesFreeList(). */

struct hapmapPrimateAlleles *hapmapPrimateAllelesLoadAllByChar(char *fileName, char chopper);
/* Load all hapmapPrimateAlleles from chopper separated file.
 * Dispose of this with hapmapPrimateAllelesFreeList(). */

#define hapmapPrimateAllelesLoadAllByTab(a) hapmapPrimateAllelesLoadAllByChar(a, '\t');
/* Load all hapmapPrimateAlleles from tab separated file.
 * Dispose of this with hapmapPrimateAllelesFreeList(). */

struct hapmapPrimateAlleles *hapmapPrimateAllelesLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all hapmapPrimateAlleles from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with hapmapPrimateAllelesFreeList(). */

void hapmapPrimateAllelesSaveToDb(struct sqlConnection *conn, struct hapmapPrimateAlleles *el, char *tableName, int updateSize);
/* Save hapmapPrimateAlleles as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct hapmapPrimateAlleles *hapmapPrimateAllelesCommaIn(char **pS, struct hapmapPrimateAlleles *ret);
/* Create a hapmapPrimateAlleles out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hapmapPrimateAlleles */

void hapmapPrimateAllelesFree(struct hapmapPrimateAlleles **pEl);
/* Free a single dynamically allocated hapmapPrimateAlleles such as created
 * with hapmapPrimateAllelesLoad(). */

void hapmapPrimateAllelesFreeList(struct hapmapPrimateAlleles **pList);
/* Free a list of dynamically allocated hapmapPrimateAlleles's */

void hapmapPrimateAllelesOutput(struct hapmapPrimateAlleles *el, FILE *f, char sep, char lastSep);
/* Print out hapmapPrimateAlleles.  Separate fields with sep. Follow last field with lastSep. */

#define hapmapPrimateAllelesTabOut(el,f) hapmapPrimateAllelesOutput(el,f,'\t','\n');
/* Print out hapmapPrimateAlleles as a line in a tab-separated file. */

#define hapmapPrimateAllelesCommaOut(el,f) hapmapPrimateAllelesOutput(el,f,',',',');
/* Print out hapmapPrimateAlleles as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* HAPMAPPRIMATEALLELES_H */

