/* jgiGene.h was originally generated by the autoSql program, which also 
 * generated jgiGene.c and jgiGene.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef JGIGENE_H
#define JGIGENE_H

#define JGIGENE_NUM_COLS 10

struct jgiGene
/* JGI curated genes */
    {
    struct jgiGene *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* JGI locus tag */
    unsigned score;	/* 1000 */
    char strand[2];	/* Value should be + or - */
    char *jgiGeneId;	/* JGI gene ID */
    char *jgiSymbol;	/* JGI gene symbol */
    float jgiGc;	/* GC content */
    char *jgiDescription;	/* ORF annotation */
    };

void jgiGeneStaticLoad(char **row, struct jgiGene *ret);
/* Load a row from jgiGene table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct jgiGene *jgiGeneLoad(char **row);
/* Load a jgiGene from row fetched with select * from jgiGene
 * from database.  Dispose of this with jgiGeneFree(). */

struct jgiGene *jgiGeneLoadAll(char *fileName);
/* Load all jgiGene from whitespace-separated file.
 * Dispose of this with jgiGeneFreeList(). */

struct jgiGene *jgiGeneLoadAllByChar(char *fileName, char chopper);
/* Load all jgiGene from chopper separated file.
 * Dispose of this with jgiGeneFreeList(). */

#define jgiGeneLoadAllByTab(a) jgiGeneLoadAllByChar(a, '\t');
/* Load all jgiGene from tab separated file.
 * Dispose of this with jgiGeneFreeList(). */

struct jgiGene *jgiGeneCommaIn(char **pS, struct jgiGene *ret);
/* Create a jgiGene out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new jgiGene */

void jgiGeneFree(struct jgiGene **pEl);
/* Free a single dynamically allocated jgiGene such as created
 * with jgiGeneLoad(). */

void jgiGeneFreeList(struct jgiGene **pList);
/* Free a list of dynamically allocated jgiGene's */

void jgiGeneOutput(struct jgiGene *el, FILE *f, char sep, char lastSep);
/* Print out jgiGene.  Separate fields with sep. Follow last field with lastSep. */

#define jgiGeneTabOut(el,f) jgiGeneOutput(el,f,'\t','\n');
/* Print out jgiGene as a line in a tab-separated file. */

#define jgiGeneCommaOut(el,f) jgiGeneOutput(el,f,',',',');
/* Print out jgiGene as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* JGIGENE_H */

