/* kg1ToKg2.h was originally generated by the autoSql program, which also 
 * generated kg1ToKg2.c and kg1ToKg2.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef KG1TOKG2_H
#define KG1TOKG2_H

#define KG1TOKG2_NUM_COLS 7

struct kg1ToKg2
/* Lists old genes and equivalent new genes if any, and reason for dropping if any. */
    {
    struct kg1ToKg2 *next;  /* Next in singly linked list. */
    char *oldId;	/* Old gene ID */
    char *oldChrom;	/* Old chromosome  */
    int oldStart;	/* Old start position */
    int oldEnd;	/* Old end position */
    char *newId;	/* New gene ID, may be empty */
    char *status;	/* How new/old correspond. Exact and compatible are good. Overlap, none are bad. */
    char *note;	/* Additional info if status if overlap or none. */
    };

void kg1ToKg2StaticLoad(char **row, struct kg1ToKg2 *ret);
/* Load a row from kg1ToKg2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct kg1ToKg2 *kg1ToKg2Load(char **row);
/* Load a kg1ToKg2 from row fetched with select * from kg1ToKg2
 * from database.  Dispose of this with kg1ToKg2Free(). */

struct kg1ToKg2 *kg1ToKg2LoadAll(char *fileName);
/* Load all kg1ToKg2 from whitespace-separated file.
 * Dispose of this with kg1ToKg2FreeList(). */

struct kg1ToKg2 *kg1ToKg2LoadAllByChar(char *fileName, char chopper);
/* Load all kg1ToKg2 from chopper separated file.
 * Dispose of this with kg1ToKg2FreeList(). */

#define kg1ToKg2LoadAllByTab(a) kg1ToKg2LoadAllByChar(a, '\t');
/* Load all kg1ToKg2 from tab separated file.
 * Dispose of this with kg1ToKg2FreeList(). */

struct kg1ToKg2 *kg1ToKg2CommaIn(char **pS, struct kg1ToKg2 *ret);
/* Create a kg1ToKg2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new kg1ToKg2 */

void kg1ToKg2Free(struct kg1ToKg2 **pEl);
/* Free a single dynamically allocated kg1ToKg2 such as created
 * with kg1ToKg2Load(). */

void kg1ToKg2FreeList(struct kg1ToKg2 **pList);
/* Free a list of dynamically allocated kg1ToKg2's */

void kg1ToKg2Output(struct kg1ToKg2 *el, FILE *f, char sep, char lastSep);
/* Print out kg1ToKg2.  Separate fields with sep. Follow last field with lastSep. */

#define kg1ToKg2TabOut(el,f) kg1ToKg2Output(el,f,'\t','\n');
/* Print out kg1ToKg2 as a line in a tab-separated file. */

#define kg1ToKg2CommaOut(el,f) kg1ToKg2Output(el,f,',',',');
/* Print out kg1ToKg2 as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* KG1TOKG2_H */

