/* liftOverChain.h was originally generated by the autoSql program, which also 
 * generated liftOverChain.c and liftOverChain.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef LIFTOVERCHAIN_H
#define LIFTOVERCHAIN_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define LIFTOVERCHAIN_NUM_COLS 9

struct liftOverChain
/* Chain file for lifting annotations between assemblies */
    {
    struct liftOverChain *next;  /* Next in singly linked list. */
    char *fromDb;	/* Short name of 'from' database.  'hg15' or the like */
    char *toDb;	/* Short name of 'to' database.  'hg16' or the like */
    char *path;	/* Path to chain file */
    float minMatch;	/* Minimum ratio of bases that must remap. */
    unsigned minChainT;	/* Minimum chain size in target. */
    unsigned minSizeQ;	/* Minimum chain size in query. */
    char multiple[2];	/* Use -multiple by default. */
    float minBlocks;	/* Min ratio of alignment blocks/exons that must map. */
    char fudgeThick[2];	/* If thickStart/thickEnd is not mapped, use the closest mapped base. */
    };

void liftOverChainStaticLoad(char **row, struct liftOverChain *ret);
/* Load a row from liftOverChain table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct liftOverChain *liftOverChainLoad(char **row);
/* Load a liftOverChain from row fetched with select * from liftOverChain
 * from database.  Dispose of this with liftOverChainFree(). */

struct liftOverChain *liftOverChainLoadAll(char *fileName);
/* Load all liftOverChain from whitespace-separated file.
 * Dispose of this with liftOverChainFreeList(). */

struct liftOverChain *liftOverChainLoadAllByChar(char *fileName, char chopper);
/* Load all liftOverChain from chopper separated file.
 * Dispose of this with liftOverChainFreeList(). */

#define liftOverChainLoadAllByTab(a) liftOverChainLoadAllByChar(a, '\t');
/* Load all liftOverChain from tab separated file.
 * Dispose of this with liftOverChainFreeList(). */

struct liftOverChain *liftOverChainLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all liftOverChain from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with liftOverChainFreeList(). */

void liftOverChainSaveToDb(struct sqlConnection *conn, struct liftOverChain *el, char *tableName, int updateSize);
/* Save liftOverChain as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct liftOverChain *liftOverChainCommaIn(char **pS, struct liftOverChain *ret);
/* Create a liftOverChain out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new liftOverChain */

void liftOverChainFree(struct liftOverChain **pEl);
/* Free a single dynamically allocated liftOverChain such as created
 * with liftOverChainLoad(). */

void liftOverChainFreeList(struct liftOverChain **pList);
/* Free a list of dynamically allocated liftOverChain's */

void liftOverChainOutput(struct liftOverChain *el, FILE *f, char sep, char lastSep);
/* Print out liftOverChain.  Separate fields with sep. Follow last field with lastSep. */

#define liftOverChainTabOut(el,f) liftOverChainOutput(el,f,'\t','\n');
/* Print out liftOverChain as a line in a tab-separated file. */

#define liftOverChainCommaOut(el,f) liftOverChainOutput(el,f,',',',');
/* Print out liftOverChain as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

boolean liftOverChainExists(struct sqlConnection *conn, char *tableName,
                                char *fromDb, char *toDb);
/* Return TRUE if row where fromDb and toDb match */

void liftOverChainRemove(struct sqlConnection *conn, char *tableName,
                                char *fromDb, char *toDb);
/* Remove rows where fromDb and toDb match */

#endif /* LIFTOVERCHAIN_H */

