/* lsSnpPdb.h was originally generated by the autoSql program, which also 
 * generated lsSnpPdb.c and lsSnpPdb.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2008 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef LSSNPPDB_H
#define LSSNPPDB_H

#define LSSNPPDB_NUM_COLS 6

enum lsSnpPdbStructType
    {
    lsSnpPdbXRay = 0,
    lsSnpPdbNMR = 1,
    };
struct lsSnpPdb
/* Mapping of SNPs to protein structures obtained from LS-SNP PDB */
    {
    struct lsSnpPdb *next;  /* Next in singly linked list. */
    char *protId;	/* Protein Id */
    char *pdbId;	/* PDB id */
    enum lsSnpPdbStructType structType;	/* type of structure */
    char chain;	/* PDB chain id */
    char *snpId;	/* dbSNP id */
    int snpPdbLoc;	/* location of SNP in PDB chain (1-based AA index) */
    };

void lsSnpPdbStaticLoad(char **row, struct lsSnpPdb *ret);
/* Load a row from lsSnpPdb table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct lsSnpPdb *lsSnpPdbLoad(char **row);
/* Load a lsSnpPdb from row fetched with select * from lsSnpPdb
 * from database.  Dispose of this with lsSnpPdbFree(). */

struct lsSnpPdb *lsSnpPdbLoadAll(char *fileName);
/* Load all lsSnpPdb from whitespace-separated file.
 * Dispose of this with lsSnpPdbFreeList(). */

struct lsSnpPdb *lsSnpPdbLoadAllByChar(char *fileName, char chopper);
/* Load all lsSnpPdb from chopper separated file.
 * Dispose of this with lsSnpPdbFreeList(). */

#define lsSnpPdbLoadAllByTab(a) lsSnpPdbLoadAllByChar(a, '\t');
/* Load all lsSnpPdb from tab separated file.
 * Dispose of this with lsSnpPdbFreeList(). */

struct lsSnpPdb *lsSnpPdbCommaIn(char **pS, struct lsSnpPdb *ret);
/* Create a lsSnpPdb out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new lsSnpPdb */

void lsSnpPdbFree(struct lsSnpPdb **pEl);
/* Free a single dynamically allocated lsSnpPdb such as created
 * with lsSnpPdbLoad(). */

void lsSnpPdbFreeList(struct lsSnpPdb **pList);
/* Free a list of dynamically allocated lsSnpPdb's */

void lsSnpPdbOutput(struct lsSnpPdb *el, FILE *f, char sep, char lastSep);
/* Print out lsSnpPdb.  Separate fields with sep. Follow last field with lastSep. */

#define lsSnpPdbTabOut(el,f) lsSnpPdbOutput(el,f,'\t','\n');
/* Print out lsSnpPdb as a line in a tab-separated file. */

#define lsSnpPdbCommaOut(el,f) lsSnpPdbOutput(el,f,',',',');
/* Print out lsSnpPdb as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* LSSNPPDB_H */

