/* singleNucDiff.h was originally generated by the autoSql program, which also 
 * generated singleNucDiff.c and singleNucDiff.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2003 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef SINGLENUCDIFF_H
#define SINGLENUCDIFF_H

#define SIMPLENUCDIFF_NUM_COLS 5

struct simpleNucDiff
/* Simple nucleotide difference */
    {
    struct simpleNucDiff *next;  /* Next in singly linked list. */
    char *chrom;	/* Target species chromosome */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *tSeq;	/* Sequence in target species */
    char *qSeq;	/* Sequence in other (query) species */
    };

void simpleNucDiffStaticLoad(char **row, struct simpleNucDiff *ret);
/* Load a row from simpleNucDiff table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct simpleNucDiff *simpleNucDiffLoad(char **row);
/* Load a simpleNucDiff from row fetched with select * from simpleNucDiff
 * from database.  Dispose of this with simpleNucDiffFree(). */

struct simpleNucDiff *simpleNucDiffLoadAll(char *fileName);
/* Load all simpleNucDiff from whitespace-separated file.
 * Dispose of this with simpleNucDiffFreeList(). */

struct simpleNucDiff *simpleNucDiffLoadAllByChar(char *fileName, char chopper);
/* Load all simpleNucDiff from chopper separated file.
 * Dispose of this with simpleNucDiffFreeList(). */

#define simpleNucDiffLoadAllByTab(a) simpleNucDiffLoadAllByChar(a, '\t');
/* Load all simpleNucDiff from tab separated file.
 * Dispose of this with simpleNucDiffFreeList(). */

struct simpleNucDiff *simpleNucDiffCommaIn(char **pS, struct simpleNucDiff *ret);
/* Create a simpleNucDiff out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new simpleNucDiff */

void simpleNucDiffFree(struct simpleNucDiff **pEl);
/* Free a single dynamically allocated simpleNucDiff such as created
 * with simpleNucDiffLoad(). */

void simpleNucDiffFreeList(struct simpleNucDiff **pList);
/* Free a list of dynamically allocated simpleNucDiff's */

void simpleNucDiffOutput(struct simpleNucDiff *el, FILE *f, char sep, char lastSep);
/* Print out simpleNucDiff.  Separate fields with sep. Follow last field with lastSep. */

#define simpleNucDiffTabOut(el,f) simpleNucDiffOutput(el,f,'\t','\n');
/* Print out simpleNucDiff as a line in a tab-separated file. */

#define simpleNucDiffCommaOut(el,f) simpleNucDiffOutput(el,f,',',',');
/* Print out simpleNucDiff as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* SINGLENUCDIFF_H */

