/* syntenyBerk.h was originally generated by the autoSql program, which also 
 * generated syntenyBerk.c and syntenyBerk.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2002 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef SYNTENYBERK_H
#define SYNTENYBERK_H

struct syntenyBerk
/* UC Berkeley Mouse Synteny */
    {
    struct syntenyBerk *next;  /* Next in singly linked list. */
    char *chrom;	/* Human Chrom */
    unsigned chromStart;	/* Start on Human */
    unsigned chromEnd;	/* End on Human */
    char *name;	/* Mouse Chromosome */
    unsigned score;	/* score always zero */
    char strand[2];	/* + direction matches - opposite */
    };

void syntenyBerkStaticLoad(char **row, struct syntenyBerk *ret);
/* Load a row from syntenyBerk table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct syntenyBerk *syntenyBerkLoad(char **row);
/* Load a syntenyBerk from row fetched with select * from syntenyBerk
 * from database.  Dispose of this with syntenyBerkFree(). */

struct syntenyBerk *syntenyBerkLoadAll(char *fileName);
/* Load all syntenyBerk from a tab-separated file.
 * Dispose of this with syntenyBerkFreeList(). */

struct syntenyBerk *syntenyBerkLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all syntenyBerk from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with syntenyBerkFreeList(). */

struct syntenyBerk *syntenyBerkCommaIn(char **pS, struct syntenyBerk *ret);
/* Create a syntenyBerk out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new syntenyBerk */

void syntenyBerkFree(struct syntenyBerk **pEl);
/* Free a single dynamically allocated syntenyBerk such as created
 * with syntenyBerkLoad(). */

void syntenyBerkFreeList(struct syntenyBerk **pList);
/* Free a list of dynamically allocated syntenyBerk's */

void syntenyBerkOutput(struct syntenyBerk *el, FILE *f, char sep, char lastSep);
/* Print out syntenyBerk.  Separate fields with sep. Follow last field with lastSep. */

#define syntenyBerkTabOut(el,f) syntenyBerkOutput(el,f,'\t','\n');
/* Print out syntenyBerk as a line in a tab-separated file. */

#define syntenyBerkCommaOut(el,f) syntenyBerkOutput(el,f,',',',');
/* Print out syntenyBerk as a comma separated list including final comma. */

#endif /* SYNTENYBERK_H */

