/* tigrOperon.h was originally generated by the autoSql program, which also 
 * generated tigrOperon.c and tigrOperon.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2004 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef TIGROPERON_H
#define TIGROPERON_H

#define TIGROPERON_NUM_COLS 4

struct tigrOperon
/* Format for TIGR operon file */
    {
    struct tigrOperon *next;  /* Next in singly linked list. */
    char *name;	/* operon name */
    unsigned size;	/* size of operon */
    char **genes;	/* gene names */
    char *info;	/* information */
    };

struct tigrOperon *tigrOperonLoad(char **row);
/* Load a tigrOperon from row fetched with select * from tigrOperon
 * from database.  Dispose of this with tigrOperonFree(). */

struct tigrOperon *tigrOperonLoadAll(char *fileName);
/* Load all tigrOperon from whitespace-separated file.
 * Dispose of this with tigrOperonFreeList(). */

struct tigrOperon *tigrOperonLoadAllByChar(char *fileName, char chopper);
/* Load all tigrOperon from chopper separated file.
 * Dispose of this with tigrOperonFreeList(). */

#define tigrOperonLoadAllByTab(a) tigrOperonLoadAllByChar(a, '\t');
/* Load all tigrOperon from tab separated file.
 * Dispose of this with tigrOperonFreeList(). */

struct tigrOperon *tigrOperonCommaIn(char **pS, struct tigrOperon *ret);
/* Create a tigrOperon out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new tigrOperon */

void tigrOperonFree(struct tigrOperon **pEl);
/* Free a single dynamically allocated tigrOperon such as created
 * with tigrOperonLoad(). */

void tigrOperonFreeList(struct tigrOperon **pList);
/* Free a list of dynamically allocated tigrOperon's */

void tigrOperonOutput(struct tigrOperon *el, FILE *f, char sep, char lastSep);
/* Print out tigrOperon.  Separate fields with sep. Follow last field with lastSep. */

#define tigrOperonTabOut(el,f) tigrOperonOutput(el,f,'\t','\n');
/* Print out tigrOperon as a line in a tab-separated file. */

#define tigrOperonCommaOut(el,f) tigrOperonOutput(el,f,',',',');
/* Print out tigrOperon as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* TIGROPERON_H */

