/* bedMethyl.c was originally generated by the autoSql program, which also 
 * generated bedMethyl.h and bedMethyl.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bedMethyl.h"



char *bedMethylCommaSepFieldNames = "chrom,chromStart,chromEnd,name,score,strand,thickStart,thickEnd,reserved,nValidCov,percMod,nMod,nCanon,nOther,nDelete,nFail,nDiff,nNoCall";

void bedMethylStaticLoad(char **row, struct bedMethyl *ret)
/* Load a row from bedMethyl table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
//ret->reserved = sqlUnsigned(row[8]);
ret->nValidCov = row[9];
ret->percMod = row[10];
ret->nMod = row[11];
ret->nCanon = row[12];
ret->nOther = row[13];
ret->nDelete = row[14];
ret->nFail = row[15];
ret->nDiff = row[16];
ret->nNoCall = row[17];
}

struct bedMethyl *bedMethylLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all bedMethyl from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with bedMethylFreeList(). */
{
struct bedMethyl *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = bedMethylLoad(&row[1]);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void bedMethylSaveToDb(struct sqlConnection *conn, struct bedMethyl *el, char *tableName, int updateSize)
/* Save bedMethyl as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s',%u,%u,'%s',%u,'%s',%u,%u,%u,'%s','%s','%s','%s','%s','%s','%s','%s','%s')", 
	tableName,  el->chrom,  el->chromStart,  el->chromEnd,  el->name,  el->score,  el->strand,  el->thickStart,  el->thickEnd,  el->reserved,  el->nValidCov,  el->percMod,  el->nMod,  el->nCanon,  el->nOther,  el->nDelete,  el->nFail,  el->nDiff,  el->nNoCall);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct bedMethyl *bedMethylLoad(char **row)
/* Load a bedMethyl from row fetched with select * from bedMethyl
 * from database.  Dispose of this with bedMethylFree(). */
{
struct bedMethyl *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
//ret->reserved = sqlUnsigned(row[8]);
ret->nValidCov = cloneString(row[9]);
ret->percMod = cloneString(row[10]);
ret->nMod = cloneString(row[11]);
ret->nCanon = cloneString(row[12]);
ret->nOther = cloneString(row[13]);
ret->nDelete = cloneString(row[14]);
ret->nFail = cloneString(row[15]);
ret->nDiff = cloneString(row[16]);
ret->nNoCall = cloneString(row[17]);
return ret;
}

struct bedMethyl *bedMethylLoadAll(char *fileName) 
/* Load all bedMethyl from a whitespace-separated file.
 * Dispose of this with bedMethylFreeList(). */
{
struct bedMethyl *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileRow(lf, row))
    {
    el = bedMethylLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bedMethyl *bedMethylLoadAllByChar(char *fileName, char chopper) 
/* Load all bedMethyl from a chopper separated file.
 * Dispose of this with bedMethylFreeList(). */
{
struct bedMethyl *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bedMethylLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bedMethyl *bedMethylCommaIn(char **pS, struct bedMethyl *ret)
/* Create a bedMethyl out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bedMethyl */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->reserved = sqlUnsignedComma(&s);
ret->nValidCov = sqlStringComma(&s);
ret->percMod = sqlStringComma(&s);
ret->nMod = sqlStringComma(&s);
ret->nCanon = sqlStringComma(&s);
ret->nOther = sqlStringComma(&s);
ret->nDelete = sqlStringComma(&s);
ret->nFail = sqlStringComma(&s);
ret->nDiff = sqlStringComma(&s);
ret->nNoCall = sqlStringComma(&s);
*pS = s;
return ret;
}

void bedMethylFree(struct bedMethyl **pEl)
/* Free a single dynamically allocated bedMethyl such as created
 * with bedMethylLoad(). */
{
struct bedMethyl *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->nValidCov);
freeMem(el->percMod);
freeMem(el->nMod);
freeMem(el->nCanon);
freeMem(el->nOther);
freeMem(el->nDelete);
freeMem(el->nFail);
freeMem(el->nDiff);
freeMem(el->nNoCall);
freez(pEl);
}

void bedMethylFreeList(struct bedMethyl **pList)
/* Free a list of dynamically allocated bedMethyl's */
{
struct bedMethyl *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bedMethylFree(&el);
    }
*pList = NULL;
}

void bedMethylOutput(struct bedMethyl *el, FILE *f, char sep, char lastSep) 
/* Print out bedMethyl.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->reserved);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nValidCov);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->percMod);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nMod);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nCanon);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nOther);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nDelete);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nFail);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nDiff);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nNoCall);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

static char *bedMethylAutoSqlString =
{
"table bedMethyl\n"
"\"Browser extensible data for bedmethyl files (bed9+9)\"\n"
"    (\n"
"    string chrom;      \"Chromosome (or contig, scaffold, etc.)\"\n"
"    uint   chromStart; \"Start position in chromosome\"\n"
"    uint   chromEnd;   \"End position in chromosome\"\n"
"    string name;       \"Name of item\"\n"
"    uint   score;      \"Score from 0-1000\"\n"
"    char[1] strand;    \"+ or -\"\n"
"    uint thickStart;   \"Start of where display should be thick (start codon)\"\n"
"    uint thickEnd;     \"End of where display should be thick (stop codon)\"\n"
"    uint reserved;     \"Used as itemRgb as of 2004-11-22\"\n"
"    string nValidCov;       \"Valid coverage|Reads with valid modification calls\"\n"
"    string percMod;       \"Percent modified|Percent of valid calls that are modified\"\n"
"    string nMod;       \"Modified calls|Number of calls with a modified base\"\n"
"    string nCanon;       \"Canonical calls|Number of calls with a canonical base\"\n"
"    string nOther;       \"Other modification calls|Number of calls with a modified base, other modification\"\n"
"    string nDelete;       \"Reads with a deletion|Number of reads with a deletion at this reference position\"\n"
"    string nFail;       \"Low-confidence calls|Number of calls where the probability of the call was below the threshold\"\n"
"    string nDiff;       \"Reads with a base mismatch|Number of reads with a base other than the canonical base for this modification\"\n"
"    string nNoCall;       \"Reads with no modification call|Number of reads aligned to this reference position, with the correct canonical base, but without a base modification call\"\n"
"    )\n"
"\n"
};

#include "asParse.h"

struct asObject *bedMethylAsObj()
/* Return asObject describing fields of bedMethyl object */
{   
return asParseText(bedMethylAutoSqlString);
}   
