# dgvPlus.sql was originally generated by the autoSql program, which also 
# generated dgvPlus.c and dgvPlus.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Database of Genomic Variants incorporating dbVar, July 2013 and later
CREATE TABLE dgvPlus (
    bin smallint not null,      # Bin number for browser speedup
    chrom varchar(255) not null,	# Reference sequence chromosome or scaffold
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# ID of merged variant or supporting variant
    score int unsigned not null,	# Score from 0-1000 (placeholder for BED 9+ format)
    strand char(1) not null,	# + or - (placeholder for BED 9+ format)
    thickStart int unsigned not null,	# Same as chromStart (placeholder for BED 9+ format)
    thickEnd int unsigned not null,	# Same as chromEnd (placeholder for BED 9+ format)
    itemRgb int unsigned not null,	# Item R,G,B color.
    varType varchar(255) not null,	# Type of variation
    reference varchar(255) not null,	# Literature reference for the study that included this variant
    pubMedId int unsigned not null,	# For linking to pubMed abstract of reference
    method longblob not null,	# Brief description of method
    platform longblob not null,	# Sequencing platform (if specified)
    mergedVariants varchar(255) not null,	# If this is a supporting variant, ID of merged variant
    supportingVariants longblob not null,	# If this is a merged variant, IDs of supporting variants
    sampleSize int unsigned not null,	# Number of samples in study
    observedGains int unsigned not null,	# Number of samples with copy number gains
    observedLosses int unsigned not null,	# Number of samples with copy number losses
    cohortDescription longblob not null,	# Description of sample population for the study
    genes longblob not null,	# Genes overlapping this variant
    samples longblob not null,	# Sample IDs if available
              #Indices
    INDEX (chrom,bin),
    INDEX (name)
);
