/* encodeStanfordPromoters.c was originally generated by the autoSql program, which also 
 * generated encodeStanfordPromoters.h and encodeStanfordPromoters.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2011 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "encode/encodeStanfordPromoters.h"


void encodeStanfordPromotersStaticLoad(char **row, struct encodeStanfordPromoters *ret)
/* Load a row from encodeStanfordPromoters table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->reserved = sqlUnsigned(row[8]);
ret->geneModel = row[9];
ret->description = row[10];
ret->lucA = sqlSigned(row[11]);
ret->renA = sqlSigned(row[12]);
ret->lucB = sqlSigned(row[13]);
ret->renB = sqlSigned(row[14]);
ret->avgRatio = atof(row[15]);
ret->normRatio = atof(row[16]);
ret->normLog2Ratio = atof(row[17]);
}

struct encodeStanfordPromoters *encodeStanfordPromotersLoad(char **row)
/* Load a encodeStanfordPromoters from row fetched with select * from encodeStanfordPromoters
 * from database.  Dispose of this with encodeStanfordPromotersFree(). */
{
struct encodeStanfordPromoters *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->reserved = sqlUnsigned(row[8]);
ret->geneModel = cloneString(row[9]);
ret->description = cloneString(row[10]);
ret->lucA = sqlSigned(row[11]);
ret->renA = sqlSigned(row[12]);
ret->lucB = sqlSigned(row[13]);
ret->renB = sqlSigned(row[14]);
ret->avgRatio = atof(row[15]);
ret->normRatio = atof(row[16]);
ret->normLog2Ratio = atof(row[17]);
return ret;
}

struct encodeStanfordPromoters *encodeStanfordPromotersLoadAll(char *fileName) 
/* Load all encodeStanfordPromoters from a whitespace-separated file.
 * Dispose of this with encodeStanfordPromotersFreeList(). */
{
struct encodeStanfordPromoters *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileRow(lf, row))
    {
    el = encodeStanfordPromotersLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct encodeStanfordPromoters *encodeStanfordPromotersLoadAllByChar(char *fileName, char chopper) 
/* Load all encodeStanfordPromoters from a chopper separated file.
 * Dispose of this with encodeStanfordPromotersFreeList(). */
{
struct encodeStanfordPromoters *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = encodeStanfordPromotersLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct encodeStanfordPromoters *encodeStanfordPromotersCommaIn(char **pS, struct encodeStanfordPromoters *ret)
/* Create a encodeStanfordPromoters out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new encodeStanfordPromoters */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->reserved = sqlUnsignedComma(&s);
ret->geneModel = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->lucA = sqlSignedComma(&s);
ret->renA = sqlSignedComma(&s);
ret->lucB = sqlSignedComma(&s);
ret->renB = sqlSignedComma(&s);
ret->avgRatio = sqlFloatComma(&s);
ret->normRatio = sqlFloatComma(&s);
ret->normLog2Ratio = sqlFloatComma(&s);
*pS = s;
return ret;
}

void encodeStanfordPromotersFree(struct encodeStanfordPromoters **pEl)
/* Free a single dynamically allocated encodeStanfordPromoters such as created
 * with encodeStanfordPromotersLoad(). */
{
struct encodeStanfordPromoters *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->geneModel);
freeMem(el->description);
freez(pEl);
}

void encodeStanfordPromotersFreeList(struct encodeStanfordPromoters **pList)
/* Free a list of dynamically allocated encodeStanfordPromoters's */
{
struct encodeStanfordPromoters *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    encodeStanfordPromotersFree(&el);
    }
*pList = NULL;
}

void encodeStanfordPromotersOutput(struct encodeStanfordPromoters *el, FILE *f, char sep, char lastSep) 
/* Print out encodeStanfordPromoters.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->reserved);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneModel);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->lucA);
fputc(sep,f);
fprintf(f, "%d", el->renA);
fputc(sep,f);
fprintf(f, "%d", el->lucB);
fputc(sep,f);
fprintf(f, "%d", el->renB);
fputc(sep,f);
fprintf(f, "%g", el->avgRatio);
fputc(sep,f);
fprintf(f, "%g", el->normRatio);
fputc(sep,f);
fprintf(f, "%g", el->normLog2Ratio);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

