/* hapmapAlleleFreq.c was originally generated by the autoSql program, which also 
 * generated hapmapAlleleFreq.h and hapmapAlleleFreq.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "hapmapAlleleFreq.h"


void hapmapAlleleFreqStaticLoad(char **row, struct hapmapAlleleFreq *ret)
/* Load a row from hapmapAlleleFreq table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->center = row[6];
strcpy(ret->refAllele, row[7]);
strcpy(ret->otherAllele, row[8]);
ret->refAlleleFreq = sqlFloat(row[9]);
ret->otherAlleleFreq = sqlFloat(row[10]);
ret->minorAlleleFreq = sqlFloat(row[11]);
ret->totalCount = sqlUnsigned(row[12]);
ret->derivedAlleleFreq = sqlFloat(row[13]);
}

struct hapmapAlleleFreq *hapmapAlleleFreqLoad(char **row)
/* Load a hapmapAlleleFreq from row fetched with select * from hapmapAlleleFreq
 * from database.  Dispose of this with hapmapAlleleFreqFree(). */
{
struct hapmapAlleleFreq *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->center = cloneString(row[6]);
strcpy(ret->refAllele, row[7]);
strcpy(ret->otherAllele, row[8]);
ret->refAlleleFreq = sqlFloat(row[9]);
ret->otherAlleleFreq = sqlFloat(row[10]);
ret->minorAlleleFreq = sqlFloat(row[11]);
ret->totalCount = sqlUnsigned(row[12]);
ret->derivedAlleleFreq = sqlFloat(row[13]);
return ret;
}

struct hapmapAlleleFreq *hapmapAlleleFreqLoadAll(char *fileName) 
/* Load all hapmapAlleleFreq from a whitespace-separated file.
 * Dispose of this with hapmapAlleleFreqFreeList(). */
{
struct hapmapAlleleFreq *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = hapmapAlleleFreqLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hapmapAlleleFreq *hapmapAlleleFreqLoadAllByChar(char *fileName, char chopper) 
/* Load all hapmapAlleleFreq from a chopper separated file.
 * Dispose of this with hapmapAlleleFreqFreeList(). */
{
struct hapmapAlleleFreq *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = hapmapAlleleFreqLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct hapmapAlleleFreq *hapmapAlleleFreqCommaIn(char **pS, struct hapmapAlleleFreq *ret)
/* Create a hapmapAlleleFreq out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hapmapAlleleFreq */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->center = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->refAllele, sizeof(ret->refAllele));
sqlFixedStringComma(&s, ret->otherAllele, sizeof(ret->otherAllele));
ret->refAlleleFreq = sqlFloatComma(&s);
ret->otherAlleleFreq = sqlFloatComma(&s);
ret->minorAlleleFreq = sqlFloatComma(&s);
ret->totalCount = sqlUnsignedComma(&s);
ret->derivedAlleleFreq = sqlFloatComma(&s);
*pS = s;
return ret;
}

void hapmapAlleleFreqFree(struct hapmapAlleleFreq **pEl)
/* Free a single dynamically allocated hapmapAlleleFreq such as created
 * with hapmapAlleleFreqLoad(). */
{
struct hapmapAlleleFreq *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->center);
freez(pEl);
}

void hapmapAlleleFreqFreeList(struct hapmapAlleleFreq **pList)
/* Free a list of dynamically allocated hapmapAlleleFreq's */
{
struct hapmapAlleleFreq *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    hapmapAlleleFreqFree(&el);
    }
*pList = NULL;
}

void hapmapAlleleFreqOutput(struct hapmapAlleleFreq *el, FILE *f, char sep, char lastSep) 
/* Print out hapmapAlleleFreq.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->center);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->refAllele);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->otherAllele);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->refAlleleFreq);
fputc(sep,f);
fprintf(f, "%g", el->otherAlleleFreq);
fputc(sep,f);
fprintf(f, "%g", el->minorAlleleFreq);
fputc(sep,f);
fprintf(f, "%u", el->totalCount);
fputc(sep,f);
fprintf(f, "%g", el->derivedAlleleFreq);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

