table pubsBlatPsl
"publications track sequence matches as PSL plus two additional fields"
    (
    int matches;          "Number of bases that match that aren't repeats"
    int misMatches;       "Number of bases that don't match"
    int repMatches;       "Number of bases that match but are part of repeats"
    int nCount;           "Number of 'N' bases"
    int qNumInsert;       "Number of inserts in query"
    int qBaseInsert;      "Number of bases inserted in query"
    int tNumInsert;       "Number of inserts in target"
    int tBaseInsert;      "Number of bases inserted in target"
    char[2] strand;       "+ or - for query strand. second +/- for genomic strand"
    string qName;         "sequence ID: 10 digits articleId, 3 digits file Id, 4 digits serial number"
    int qSize;            "Query sequence size"
    int qStart;           "Alignment start position in query"
    int qEnd;             "Alignment end position in query"
    string tName;         "Target sequence name"
    int tSize;            "Target sequence size"
    int tStart;           "Alignment start position in target"
    int tEnd;             "Alignment end position in target"
    int blockCount;       "Number of blocks in alignment"
    lstring blockSizes;   "Size of each block"
    lstring qStarts;      "Start of each block in query."
    lstring tStarts;      "Start of each block in target."
    string tSeqType;      "types of matching sequence db: g=genome, c=cdna, p=protein (comma-sep)"
    bigint articleId;     "articleId of article in hgFixed.pubsBingArticle"
    )
