/* stsInfoMouseNew.c was originally generated by the autoSql program, which also 
 * generated stsInfoMouseNew.h and stsInfoMouseNew.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "stsInfoMouseNew.h"


void stsInfoMouseNewStaticLoad(char **row, struct stsInfoMouseNew *ret)
/* Load a row from stsInfoMouseNew table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->identNo = sqlUnsigned(row[0]);
ret->name = row[1];
ret->MGIId = sqlUnsigned(row[2]);
ret->MGIName = row[3];
ret->UiStsId = sqlUnsigned(row[4]);
ret->nameCount = sqlUnsigned(row[5]);
ret->alias = row[6];
ret->primer1 = row[7];
ret->primer2 = row[8];
ret->distance = row[9];
ret->sequence = sqlUnsigned(row[10]);
ret->organis = row[11];
ret->wigName = row[12];
ret->wigChr = row[13];
ret->wigGeneticPos = atof(row[14]);
ret->mgiName = row[15];
ret->mgiChr = row[16];
ret->mgiGeneticPos = atof(row[17]);
ret->rhName = row[18];
ret->rhChr = row[19];
ret->rhGeneticPos = atof(row[20]);
ret->RHLOD = atof(row[21]);
ret->GeneName = row[22];
ret->GeneID = row[23];
ret->clone = row[24];
}

struct stsInfoMouseNew *stsInfoMouseNewLoad(char **row)
/* Load a stsInfoMouseNew from row fetched with select * from stsInfoMouseNew
 * from database.  Dispose of this with stsInfoMouseNewFree(). */
{
struct stsInfoMouseNew *ret;

AllocVar(ret);
ret->identNo = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->MGIId = sqlUnsigned(row[2]);
ret->MGIName = cloneString(row[3]);
ret->UiStsId = sqlUnsigned(row[4]);
ret->nameCount = sqlUnsigned(row[5]);
ret->alias = cloneString(row[6]);
ret->primer1 = cloneString(row[7]);
ret->primer2 = cloneString(row[8]);
ret->distance = cloneString(row[9]);
ret->sequence = sqlUnsigned(row[10]);
ret->organis = cloneString(row[11]);
ret->wigName = cloneString(row[12]);
ret->wigChr = cloneString(row[13]);
ret->wigGeneticPos = atof(row[14]);
ret->mgiName = cloneString(row[15]);
ret->mgiChr = cloneString(row[16]);
ret->mgiGeneticPos = atof(row[17]);
ret->rhName = cloneString(row[18]);
ret->rhChr = cloneString(row[19]);
ret->rhGeneticPos = atof(row[20]);
ret->RHLOD = atof(row[21]);
ret->GeneName = cloneString(row[22]);
ret->GeneID = cloneString(row[23]);
ret->clone = cloneString(row[24]);
return ret;
}

struct stsInfoMouseNew *stsInfoMouseNewLoadAll(char *fileName) 
/* Load all stsInfoMouseNew from a whitespace-separated file.
 * Dispose of this with stsInfoMouseNewFreeList(). */
{
struct stsInfoMouseNew *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[25];

while (lineFileRow(lf, row))
    {
    el = stsInfoMouseNewLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct stsInfoMouseNew *stsInfoMouseNewLoadAllByChar(char *fileName, char chopper) 
/* Load all stsInfoMouseNew from a chopper separated file.
 * Dispose of this with stsInfoMouseNewFreeList(). */
{
struct stsInfoMouseNew *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[25];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = stsInfoMouseNewLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct stsInfoMouseNew *stsInfoMouseNewCommaIn(char **pS, struct stsInfoMouseNew *ret)
/* Create a stsInfoMouseNew out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new stsInfoMouseNew */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->identNo = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->MGIId = sqlUnsignedComma(&s);
ret->MGIName = sqlStringComma(&s);
ret->UiStsId = sqlUnsignedComma(&s);
ret->nameCount = sqlUnsignedComma(&s);
ret->alias = sqlStringComma(&s);
ret->primer1 = sqlStringComma(&s);
ret->primer2 = sqlStringComma(&s);
ret->distance = sqlStringComma(&s);
ret->sequence = sqlUnsignedComma(&s);
ret->organis = sqlStringComma(&s);
ret->wigName = sqlStringComma(&s);
ret->wigChr = sqlStringComma(&s);
ret->wigGeneticPos = sqlFloatComma(&s);
ret->mgiName = sqlStringComma(&s);
ret->mgiChr = sqlStringComma(&s);
ret->mgiGeneticPos = sqlFloatComma(&s);
ret->rhName = sqlStringComma(&s);
ret->rhChr = sqlStringComma(&s);
ret->rhGeneticPos = sqlFloatComma(&s);
ret->RHLOD = sqlFloatComma(&s);
ret->GeneName = sqlStringComma(&s);
ret->GeneID = sqlStringComma(&s);
ret->clone = sqlStringComma(&s);
*pS = s;
return ret;
}

void stsInfoMouseNewFree(struct stsInfoMouseNew **pEl)
/* Free a single dynamically allocated stsInfoMouseNew such as created
 * with stsInfoMouseNewLoad(). */
{
struct stsInfoMouseNew *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->MGIName);
freeMem(el->alias);
freeMem(el->primer1);
freeMem(el->primer2);
freeMem(el->distance);
freeMem(el->organis);
freeMem(el->wigName);
freeMem(el->wigChr);
freeMem(el->mgiName);
freeMem(el->mgiChr);
freeMem(el->rhName);
freeMem(el->rhChr);
freeMem(el->GeneName);
freeMem(el->GeneID);
freeMem(el->clone);
freez(pEl);
}

void stsInfoMouseNewFreeList(struct stsInfoMouseNew **pList)
/* Free a list of dynamically allocated stsInfoMouseNew's */
{
struct stsInfoMouseNew *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    stsInfoMouseNewFree(&el);
    }
*pList = NULL;
}

void stsInfoMouseNewOutput(struct stsInfoMouseNew *el, FILE *f, char sep, char lastSep) 
/* Print out stsInfoMouseNew.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->identNo);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->MGIId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->MGIName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->UiStsId);
fputc(sep,f);
fprintf(f, "%u", el->nameCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->alias);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->primer1);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->primer2);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->distance);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->sequence);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->organis);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->wigName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->wigChr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->wigGeneticPos);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mgiName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mgiChr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->mgiGeneticPos);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rhName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rhChr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->rhGeneticPos);
fputc(sep,f);
fprintf(f, "%f", el->RHLOD);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->GeneName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->GeneID);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->clone);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

