table pubsBlat2
"publications blat feature table, in bed12+ format"
    (
    string chrom;         "chromosome"
    int chromStart;       "start position on chromosome"
    int chromEnd;         "end position on chromosome"
    string name;          "internal articleId, article that matches here"
    int score;            "score of feature"
    char[1] strand;       "strand of feature"
    int thickStart;       "start of exons"
    int thickEnd;         "end of exons"
    int reserved;         "no clue"
    int blockCount;       "number of blocks"
    lstring blockSizes;   "size of blocks"
    lstring chromStarts;  "A comma-separated list of block starts"
    string tSeqTypes;     "comma-seq list of matching sequence db (g=genome, p=protein, c=cDNA)"
    lstring seqIds;       "comma-separated list of matching seqIds"
    lstring seqRanges;    "ranges start-end on sequence that matched, one for each seqId"
    string publisher;     "publisher of article, for hgTracks feature filter"
    string pmid;          "PMID of article, for annoGrator output, avoids table join"
    string doi;           "doi of article, for annoGrator output, avoids table join"
    string issn;          "issn of journal"
    string journal;       "name of journal"
    string title;         "title of article, for genome browser mouseover"
    string firstAuthor;   "first author family name of article, for genome browser"
    string year;          "year of article, for genome browser"
    string impact;        "impact factor of journal, for genome browser coloring, derived from official impact factors: max impact is 25, value is scaled to 0-255"
    string classes;       "classes assigned to journal article, for genome browser coloring"
    string locus;         "closest gene symbols, one or two, comma-separated"
    )
