# rnaHybridization.sql was originally generated by the autoSql program, which also 
# generated rnaHybridization.c and rnaHybridization.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#perfect hybridizations on RNA level
CREATE TABLE rnaHybridization (
    chrom varchar(255) not null,	# Reference sequence chromosome or scaffold
    chromStart int unsigned not null,	# Start position in chromosome for pattern region
    chromEnd int unsigned not null,	# End position in chromosome for pattern region
    name varchar(255) not null,	# match name
    dummy int unsigned not null,	# dummy field to align with bed 6 structure
    strand char(1) not null,	# strand for pattern region
    chromTarget varchar(255) not null,	# Reference sequence chromosome for target region
    chromStartTarget int unsigned not null,	# Start position in chromosome for target region
    chromEndTarget int unsigned not null,	# End position in chromosome for target region
    strandTarget char(1) not null,	# strand for target region
    refSeqTarget varchar(255) not null,	# refSeq gene name for target or empty
    aorfTarget varchar(255) not null,	# AORF gene name for target or empty
    igenicsTarget varchar(255) not null,	# intergenics name for target or empty
    trnaTarget varchar(255) not null,	# 
    JGITarget varchar(255) not null,	# 
    patternSeq varchar(255) not null,	# Sequence of pattern region 5'-3'
    targetSeq varchar(255) not null,	# Sequence of target region 3'-5'
    gcContent float not null,	# GC content ranging from 0 to 1
    matchLength int unsigned not null,	# Length of hybridization site
    targetAnnotation int unsigned not null,	# 1 if target is annotated on same strand, zero otherwise
              #Indices
    PRIMARY KEY(chrom,chromStart,chromEnd,strand,chromTarget,chromStartTarget,chromEndTarget,strandTarget)
);
