table txAliDiff
"Differences between reference genome and transcript sequences"
    (   
    string chrom;       "Reference sequence chromosome or scaffold"
    uint   chromStart;  "Start position in chromosome of ambiguous gap placement region"
    uint   chromEnd;    "End position in chromosome of ambiguous gap placement region"
    string name;        "Name of item"
    uint   score;       "Not used"
    char[1] strand;     "Transcript orientation on genome: + or -"
    uint   thickStart;  "Start position of 3'-most location for gaps that can shift position without introducing mismatches"
    uint   thickEnd;    "End position of 3'-most gap location for gaps that can shift position without introducing mismatches"
    uint reserved;         "RGB color of this item"
    string txName;      "Transcript identifier"
    uint   txStart;     "Start position in transcript (of ambiguous gap placement region where applicable)"
    uint   txEnd;       "End position in transcript (of ambiguous gap placement region where applicable)"
    uint gSkipped;    "Number of bases skipped on genome, if any"
    uint txSkipped;   "Number of bases skipped on transcript, if any"
    uint shiftL;      "Number of bases that gap can be shifted left on genome with no mismatches"
    uint shiftR;      "Number of bases that gap can be shifted right on genome with no mismatches" 
    lstring hgvsG;      "HGVS g. notation of genome change to match transcript"
    lstring hgvsCN;     "HGVS c./n. notation of part of transcript not matched in genome"
    lstring hgvsN;      "HGVS c./n. notation of transcript change to match genome"
    lstring hgvsPosCN;  "HGVS c./n. position range of transcript ambiguous gap placement region"
    )
