/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.common.collect.Lists;
import com.google.jstestdriver.coverage.CoverageWriter;
import com.google.jstestdriver.coverage.CoveredLine;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCoverage
implements Comparable<FileCoverage> {
    private Integer fileId;
    private List<CoveredLine> lines = Lists.newLinkedList();

    public FileCoverage() {
    }

    public FileCoverage(Integer fileId, List<CoveredLine> lines) {
        this.fileId = fileId;
        this.lines = lines;
    }

    public FileCoverage aggegrate(FileCoverage other) {
        if (this.fileId.equals(other.fileId)) {
            LinkedList rawLines = Lists.newLinkedList();
            rawLines.addAll(this.lines);
            rawLines.addAll(other.lines);
            Collections.sort(rawLines);
            LinkedList newLines = Lists.newLinkedList();
            if (!rawLines.isEmpty()) {
                CoveredLine current = (CoveredLine)rawLines.remove(0);
                for (CoveredLine line : rawLines) {
                    CoveredLine aggregate = current.aggegrate(line);
                    if (aggregate == null) {
                        newLines.add(current);
                        current = line;
                        continue;
                    }
                    current = aggregate;
                }
                newLines.add(current);
            }
            return new FileCoverage(this.fileId, newLines);
        }
        return null;
    }

    public void write(CoverageWriter coverageWriter) {
        coverageWriter.writeRecordStart(this.fileId);
        for (CoveredLine line : this.lines) {
            line.write(coverageWriter);
        }
        coverageWriter.writeRecordEnd();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lines == null ? 0 : ((Object)this.lines).hashCode());
        result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileCoverage other = (FileCoverage)obj;
        if (this.lines == null ? other.lines != null : !((Object)this.lines).equals(other.lines)) {
            return false;
        }
        return !(this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId));
    }

    @Override
    public int compareTo(FileCoverage o) {
        return this.fileId.compareTo(o.fileId);
    }

    public String toString() {
        return String.format("%s(%s, %s)", this.getClass().getSimpleName(), this.fileId, this.lines);
    }
}

