/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.common.collect.Lists;
import com.google.jstestdriver.coverage.CoveredLine;
import com.google.jstestdriver.coverage.FileCoverage;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCoverageDeserializer {
    public FileCoverage deserializeCoverage(InputStream in) throws IOException {
        int fileId = this.parseToIntEndingWith(in, ',');
        this.verifyAndConsumeToken(in, '[');
        List<CoveredLine> lines = this.deserializeLines(in);
        return new FileCoverage(fileId, lines);
    }

    public List<FileCoverage> deserializeCoverages(InputStream in) throws IOException {
        this.verifyAndConsumeToken(in, '[');
        LinkedList coverages = Lists.newLinkedList();
        char next = this.consumeToken(in);
        while (next == '[') {
            coverages.add(this.deserializeCoverage(in));
            next = this.conditionalConsumeToken(in, ',');
        }
        this.verifyToken(next, ']');
        return coverages;
    }

    public List<CoveredLine> deserializeLines(InputStream in) throws IOException {
        LinkedList lines = Lists.newLinkedList();
        char next = this.consumeToken(in);
        while (next == '[') {
            lines.add(this.deserializeLine(in));
            next = this.consumeToken(in);
            next = this.conditionalConsumeToken(in, ',');
        }
        this.verifyToken(next, ']');
        return lines;
    }

    public CoveredLine deserializeLine(InputStream in) throws IOException {
        int lineNumber = this.parseToIntEndingWith(in, ',');
        int executedNumber = this.parseToIntEndingWith(in, ']');
        return new CoveredLine(lineNumber, executedNumber);
    }

    private char conditionalConsumeToken(InputStream in, char consumable) throws IOException {
        char next = this.consumeToken(in);
        if (next == consumable) {
            next = this.consumeToken(in);
        }
        return next;
    }

    private void verifyToken(char next, char expected) {
        if (next != expected) {
            throw new RuntimeException(String.format("unrecognized format, expected %s  was %s", Character.valueOf(expected), Character.valueOf(next)));
        }
    }

    private int parseToIntEndingWith(InputStream in, char delim) throws IOException {
        StringBuilder intBuilder = new StringBuilder();
        char token = this.consumeToken(in);
        while (token != delim) {
            intBuilder.append(token);
            token = this.consumeToken(in);
        }
        return Integer.parseInt(intBuilder.toString());
    }

    private void verifyAndConsumeToken(InputStream in, char expected) throws IOException {
        char token = this.consumeToken(in);
        if (token != expected) {
            throw new RuntimeException(String.format("unrecognized format, expected %s  was %s", Character.valueOf(expected), Character.valueOf(token)));
        }
    }

    private char consumeToken(InputStream in) throws IOException {
        char token = (char)in.read();
        while (token == ' ') {
            token = (char)in.read();
        }
        return token;
    }
}

