/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.jstestdriver.coverage.CoverageNameMapper;
import com.google.jstestdriver.coverage.CoverageWriter;
import java.io.IOException;
import java.io.OutputStream;

public class SummaryCoverageWriter
implements CoverageWriter {
    private String qualifiedFile;
    private float totalLines = 0.0f;
    private float executed = 0.0f;
    private final OutputStream out;
    private final CoverageNameMapper mapper;

    public SummaryCoverageWriter(OutputStream out, CoverageNameMapper mapper) {
        this.out = out;
        this.mapper = mapper;
    }

    public void flush() {
    }

    public void writeCoverage(int lineNumber, int executedNumber) {
        this.totalLines += 1.0f;
        if (executedNumber > 0) {
            this.executed += 1.0f;
        }
    }

    public void writeRecordEnd() {
        float percent = this.executed / this.totalLines * 100.0f;
        try {
            this.out.write(String.format("%s: %s%% covered\n", this.qualifiedFile, Float.valueOf(percent)).getBytes());
            this.totalLines = 0.0f;
            this.executed = 0.0f;
            this.qualifiedFile = "";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeRecordStart(Integer fileId) {
        this.qualifiedFile = this.mapper.unmap(fileId);
    }
}

