/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Guice;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.JsTestDriverServer;
import com.google.jstestdriver.browser.BrowserReaper;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.server.JettyModule;
import com.google.jstestdriver.server.handlers.JstdHandlersModule;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;
import java.util.Timer;
import java.util.TimerTask;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsTestDriverServerImpl
extends Observable
implements JsTestDriverServer {
    private static final Logger logger = LoggerFactory.getLogger(JsTestDriverServerImpl.class);
    private Server server;
    private final int port;
    private final CapturedBrowsers capturedBrowsers;
    private final FilesCache filesCache;
    private final long browserTimeout;
    private Timer timer;
    private final HandlerPathPrefix handlerPrefix;

    public JsTestDriverServerImpl(int port, CapturedBrowsers capturedBrowsers, FilesCache preloadedFilesCache, long browserTimeout, HandlerPathPrefix handlerPrefix) {
        this.port = port;
        this.capturedBrowsers = capturedBrowsers;
        this.filesCache = preloadedFilesCache;
        this.browserTimeout = browserTimeout;
        this.handlerPrefix = handlerPrefix;
        this.initServer();
    }

    private void initServer() {
        if (this.server != null) {
            logger.warn("Attempt to start a started server");
        } else {
            this.server = Guice.createInjector(new JettyModule(this.port, this.handlerPrefix), new JstdHandlersModule(this.capturedBrowsers, this.filesCache, this.browserTimeout, this.handlerPrefix)).getInstance(Server.class);
            this.server.addLifeCycleListener(new JettyLifeCycleLogger());
        }
    }

    public void start() {
        try {
            this.initServer();
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new BrowserReaper(this.capturedBrowsers), this.browserTimeout * 2L, this.browserTimeout * 2L);
            this.server.start();
            this.setChanged();
            this.notifyObservers((Object)JsTestDriverServer.Event.STARTED);
            logger.info("Started the JsTD server on {}", this.port);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.timer.cancel();
            if (this.server != null) {
                this.server.stop();
                this.server.join();
                this.server = null;
            }
            this.setChanged();
            this.notifyObservers((Object)JsTestDriverServer.Event.STOPPED);
            logger.debug("Stopped the server.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isHealthy() {
        String url = "http://localhost:" + this.port + this.handlerPrefix.prefixPath("/hello");
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                return true;
            }
            logger.warn("Bad response code {} from server: {}", responseCode, connection.getContent());
            return false;
        }
        catch (MalformedURLException e) {
            logger.warn("Bad url {}", e);
        }
        catch (IOException e) {
            logger.warn("Server not ready.", e);
        }
        return false;
    }

    private static final class JettyLifeCycleLogger
    implements LifeCycle.Listener {
        private JettyLifeCycleLogger() {
        }

        public void lifeCycleStopping(LifeCycle arg0) {
            logger.debug("Server stopping");
        }

        public void lifeCycleStopped(LifeCycle arg0) {
            logger.debug("Server stopped");
        }

        public void lifeCycleStarting(LifeCycle arg0) {
            logger.debug("Server starting");
        }

        public void lifeCycleStarted(LifeCycle arg0) {
            logger.debug("Server started");
        }

        public void lifeCycleFailure(LifeCycle arg0, Throwable arg1) {
            logger.warn("Server failed", arg1);
        }
    }
}

