/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.jstestdriver.Time;
import java.util.Set;

public class BrowserIdStrategy {
    private final Time time;
    private final Set<Long> used = Sets.newHashSet();

    @Inject
    public BrowserIdStrategy(Time time) {
        this.time = time;
    }

    public synchronized Long nextId() {
        long nextId = this.time.now().getMillis();
        while (this.used.contains(nextId)) {
            ++nextId;
        }
        this.used.add(nextId);
        return nextId;
    }
}

