/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.directoryscanner;

import com.google.jstestdriver.directoryscanner.DirectoryScannerException;
import com.google.jstestdriver.directoryscanner.FileScanner;
import com.google.jstestdriver.directoryscanner.FileSelector;
import com.google.jstestdriver.directoryscanner.FileUtils;
import com.google.jstestdriver.directoryscanner.Os;
import com.google.jstestdriver.directoryscanner.SelectorScanner;
import com.google.jstestdriver.directoryscanner.SelectorUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScanner
implements FileScanner,
SelectorScanner {
    private static final boolean ON_VMS = Os.isFamily("openvms");
    private static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final boolean[] CS_SCAN_ONLY = new boolean[]{true};
    private static final boolean[] CS_THEN_NON_CS = new boolean[]{true, false};
    private static Vector<String> defaultExcludes = new Vector();
    private File basedir;
    private String[] includes;
    private String[] excludes;
    private FileSelector[] selectors = null;
    private Vector<String> filesIncluded;
    private Vector<String> filesNotIncluded;
    private Vector<String> filesExcluded;
    private Vector<String> dirsIncluded;
    private Vector<String> dirsNotIncluded;
    private Vector<String> dirsExcluded;
    private Vector<String> filesDeselected;
    private Vector<String> dirsDeselected;
    private boolean haveSlowResults = false;
    private boolean isCaseSensitive = true;
    private boolean errorOnMissingDir = true;
    private boolean followSymlinks = true;
    private boolean everythingIncluded = true;
    private Map<File, String[]> fileListMap = new HashMap<File, String[]>();
    private Set<String> scannedDirs = new HashSet<String>();
    private Set<String> includeNonPatterns = new HashSet<String>();
    private Set<String> excludeNonPatterns = new HashSet<String>();
    private String[] includePatterns;
    private String[] excludePatterns;
    private boolean areNonPatternSetsReady = false;
    private boolean scanning = false;
    private Object scanLock = new Object();
    private boolean slowScanning = false;
    private Object slowScanLock = new Object();
    private IllegalStateException illegal = null;

    protected static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str);
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern, str, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str);
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str, isCaseSensitive);
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.match(pattern, str, isCaseSensitive);
    }

    public static String[] getDefaultExcludes() {
        return defaultExcludes.toArray(new String[defaultExcludes.size()]);
    }

    public static boolean addDefaultExclude(String s) {
        if (defaultExcludes.indexOf(s) == -1) {
            defaultExcludes.add(s);
            return true;
        }
        return false;
    }

    public static boolean removeDefaultExclude(String s) {
        return defaultExcludes.remove(s);
    }

    public static void resetDefaultExcludes() {
        defaultExcludes = new Vector();
        for (int i = 0; i < DEFAULTEXCLUDES.length; ++i) {
            defaultExcludes.add(DEFAULTEXCLUDES[i]);
        }
    }

    @Override
    public void setBasedir(String basedir) {
        this.setBasedir(basedir == null ? (File)null : new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    @Override
    public synchronized void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    @Override
    public synchronized File getBasedir() {
        return this.basedir;
    }

    public synchronized boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public synchronized void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void setErrorOnMissingDir(boolean errorOnMissingDir) {
        this.errorOnMissingDir = errorOnMissingDir;
    }

    public synchronized boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public synchronized void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    @Override
    public synchronized void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                this.includes[i] = DirectoryScanner.normalizePattern(includes[i]);
            }
        }
    }

    @Override
    public synchronized void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                this.excludes[i] = DirectoryScanner.normalizePattern(excludes[i]);
            }
        }
    }

    public synchronized void addExcludes(String[] excludes) {
        if (excludes != null && excludes.length > 0) {
            if (this.excludes != null && this.excludes.length > 0) {
                String[] tmp = new String[excludes.length + this.excludes.length];
                System.arraycopy(this.excludes, 0, tmp, 0, this.excludes.length);
                for (int i = 0; i < excludes.length; ++i) {
                    tmp[this.excludes.length + i] = DirectoryScanner.normalizePattern(excludes[i]);
                }
                this.excludes = tmp;
            } else {
                this.setExcludes(excludes);
            }
        }
    }

    private static String normalizePattern(String p) {
        String pattern = p.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (pattern.endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    @Override
    public synchronized void setSelectors(FileSelector[] selectors) {
        this.selectors = selectors;
    }

    public synchronized boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void scan() throws IllegalStateException {
        block42: {
            var1_1 = this.scanLock;
            synchronized (var1_1) {
                if (this.scanning) {
                    while (this.scanning) {
                        try {
                            this.scanLock.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                    if (this.illegal != null) {
                        throw this.illegal;
                    }
                    return;
                }
                this.scanning = true;
            }
            var1_1 = this;
            synchronized (var1_1) {
                this.illegal = null;
                this.clearResults();
                v0 = nullIncludes = this.includes == null;
                if (nullIncludes) {
                    v1 = new String[1];
                    v2 = v1;
                    v1[0] = "**";
                } else {
                    v2 = this.includes;
                }
                this.includes = v2;
                nullExcludes = this.excludes == null;
                v3 = this.excludes = nullExcludes != false ? new String[]{} : this.excludes;
                if (this.basedir != null) ** break block40
                if (!nullIncludes) ** GOTO lbl69
                // MONITOREXIT @DISABLED, blocks:[2, 3, 12] lbl39 : MonitorExitStatement: MONITOREXIT : var1_1
                var4_6 = this.scanLock;
            }
            synchronized (var4_6) {
                this.scanning = false;
                this.scanLock.notifyAll();
            }
            return;
            {
                if (this.basedir.exists()) ** break block41
                if (this.errorOnMissingDir) {
                    this.illegal = new IllegalStateException("basedir " + this.basedir + " does not exist");
                    ** break block41
                }
                // MONITOREXIT @DISABLED, blocks:[5, 12] lbl56 : MonitorExitStatement: MONITOREXIT : var1_1
                var4_7 = this.scanLock;
            }
            synchronized (var4_7) {
                this.scanning = false;
                this.scanLock.notifyAll();
            }
            return;
lbl-1000:
            // 2 sources

            {
                if (!this.basedir.isDirectory()) {
                    this.illegal = new IllegalStateException("basedir " + this.basedir + " is not a directory");
                }
                if (this.illegal != null) {
                    throw this.illegal;
                }
lbl69:
                // 3 sources

                if (this.isIncluded("")) {
                    if (!this.isExcluded("")) {
                        if (this.isSelected("", this.basedir)) {
                            this.dirsIncluded.addElement("");
                        } else {
                            this.dirsDeselected.addElement("");
                        }
                    } else {
                        this.dirsExcluded.addElement("");
                    }
                } else {
                    this.dirsNotIncluded.addElement("");
                }
                this.checkIncludePatterns();
                this.clearCaches();
                this.includes = nullIncludes != false ? null : this.includes;
                this.excludes = nullExcludes != false ? null : this.excludes;
                break block42;
                {
                    catch (Throwable var7_10) {
                        throw var7_10;
                    }
                }
            }
            {
                finally {
                    var1_1 = this.scanLock;
                    synchronized (var1_1) {
                        this.scanning = false;
                        this.scanLock.notifyAll();
                    }
                }
            }
        }
    }

    private void checkIncludePatterns() {
        HashMap<String, String> newroots = new HashMap<String, String>();
        for (int i = 0; i < this.includes.length; ++i) {
            if (FileUtils.isAbsolutePath(this.includes[i]) ? this.basedir != null && !SelectorUtils.matchPatternStart(this.includes[i], this.basedir.getAbsolutePath(), this.isCaseSensitive()) : this.basedir == null) continue;
            newroots.put(SelectorUtils.rtrimWildcardTokens(this.includes[i]), this.includes[i]);
        }
        if (newroots.containsKey("") && this.basedir != null) {
            this.scandir(this.basedir, "", true);
        } else {
            Iterator it = newroots.entrySet().iterator();
            File canonBase = null;
            if (this.basedir != null) {
                try {
                    canonBase = this.basedir.getCanonicalFile();
                }
                catch (IOException ex) {
                    throw new DirectoryScannerException(ex);
                }
            }
            while (it.hasNext()) {
                File f;
                Map.Entry entry = it.next();
                String currentelement = (String)entry.getKey();
                if (this.basedir == null && !FileUtils.isAbsolutePath(currentelement)) continue;
                String originalpattern = (String)entry.getValue();
                File myfile = new File(this.basedir, currentelement);
                if (myfile.exists()) {
                    try {
                        String path;
                        String string = path = this.basedir == null ? myfile.getCanonicalPath() : FILE_UTILS.removeLeadingPath(canonBase, myfile.getCanonicalFile());
                        if ((!path.equals(currentelement) || ON_VMS) && (myfile = this.findFile(this.basedir, currentelement, true)) != null && this.basedir != null) {
                            currentelement = FILE_UTILS.removeLeadingPath(this.basedir, myfile);
                        }
                    }
                    catch (IOException ex) {
                        throw new DirectoryScannerException(ex);
                    }
                }
                if (!(myfile != null && myfile.exists() || this.isCaseSensitive() || (f = this.findFile(this.basedir, currentelement, false)) == null || !f.exists())) {
                    currentelement = this.basedir == null ? f.getAbsolutePath() : FILE_UTILS.removeLeadingPath(this.basedir, f);
                    myfile = f;
                }
                if (myfile == null || !myfile.exists() || !this.followSymlinks && this.isSymlink(this.basedir, currentelement)) continue;
                if (myfile.isDirectory()) {
                    if (this.isIncluded(currentelement) && currentelement.length() > 0) {
                        this.accountForIncludedDir(currentelement, myfile, true);
                        continue;
                    }
                    if (currentelement.length() > 0 && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                        currentelement = currentelement + File.separatorChar;
                    }
                    this.scandir(myfile, currentelement, true);
                    continue;
                }
                boolean included = this.isCaseSensitive() ? originalpattern.equals(currentelement) : originalpattern.equalsIgnoreCase(currentelement);
                if (!included) continue;
                this.accountForIncludedFile(currentelement, myfile);
            }
        }
    }

    protected synchronized void clearResults() {
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        this.everythingIncluded = this.basedir != null;
        this.scannedDirs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void slowScan() {
        Object object = this.slowScanLock;
        synchronized (object) {
            if (this.haveSlowResults) {
                return;
            }
            if (this.slowScanning) {
                while (this.slowScanning) {
                    try {
                        this.slowScanLock.wait();
                    }
                    catch (InterruptedException e) {}
                }
                return;
            }
            this.slowScanning = true;
        }
        try {
            object = this;
            synchronized (object) {
                String[] stringArray;
                boolean nullIncludes;
                boolean bl = nullIncludes = this.includes == null;
                if (nullIncludes) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "**";
                } else {
                    stringArray = this.includes;
                }
                this.includes = stringArray;
                boolean nullExcludes = this.excludes == null;
                this.excludes = nullExcludes ? new String[]{} : this.excludes;
                Object[] excl = new String[this.dirsExcluded.size()];
                this.dirsExcluded.copyInto(excl);
                Object[] notIncl = new String[this.dirsNotIncluded.size()];
                this.dirsNotIncluded.copyInto(notIncl);
                this.processSlowScan((String[])excl);
                this.processSlowScan((String[])notIncl);
                this.clearCaches();
                this.includes = nullIncludes ? null : this.includes;
                this.excludes = nullExcludes ? null : this.excludes;
            }
        }
        finally {
            object = this.slowScanLock;
            synchronized (object) {
                this.haveSlowResults = true;
                this.slowScanning = false;
                this.slowScanLock.notifyAll();
            }
        }
    }

    private void processSlowScan(String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (this.couldHoldIncluded(arr[i])) continue;
            this.scandir(new File(this.basedir, arr[i]), arr[i] + File.separator, false);
        }
    }

    protected void scandir(File dir, String vpath, boolean fast) {
        if (dir == null) {
            throw new DirectoryScannerException("dir must not be null.");
        }
        String[] newfiles = dir.list();
        if (newfiles == null) {
            if (!dir.exists()) {
                throw new DirectoryScannerException(dir + " doesn't exist.");
            }
            if (!dir.isDirectory()) {
                throw new DirectoryScannerException(dir + " is not a directory.");
            }
            throw new DirectoryScannerException("IO error scanning directory '" + dir.getAbsolutePath() + "'");
        }
        this.scandir(dir, vpath, fast, newfiles);
    }

    private void scandir(File dir, String vpath, boolean fast, String[] newfiles) {
        if (fast && this.hasBeenScanned(vpath)) {
            return;
        }
        if (!this.followSymlinks) {
            Vector<String> noLinks = new Vector<String>();
            for (int i = 0; i < newfiles.length; ++i) {
                try {
                    if (FILE_UTILS.isSymbolicLink(dir, newfiles[i])) {
                        String name = vpath + newfiles[i];
                        File file = new File(dir, newfiles[i]);
                        (file.isDirectory() ? this.dirsExcluded : this.filesExcluded).addElement(name);
                        continue;
                    }
                    noLinks.addElement(newfiles[i]);
                    continue;
                }
                catch (IOException ioe) {
                    String msg = "IOException caught while checking for links, couldn't get canonical path!";
                    System.err.println(msg);
                    noLinks.addElement(newfiles[i]);
                }
            }
            newfiles = noLinks.toArray(new String[noLinks.size()]);
        }
        for (int i = 0; i < newfiles.length; ++i) {
            String name = vpath + newfiles[i];
            File file = new File(dir, newfiles[i]);
            String[] children = file.list();
            if (children == null) {
                if (this.isIncluded(name)) {
                    this.accountForIncludedFile(name, file);
                    continue;
                }
                this.everythingIncluded = false;
                this.filesNotIncluded.addElement(name);
                continue;
            }
            if (this.isIncluded(name)) {
                this.accountForIncludedDir(name, file, fast, children);
            } else {
                this.everythingIncluded = false;
                this.dirsNotIncluded.addElement(name);
                if (fast && this.couldHoldIncluded(name)) {
                    this.scandir(file, name + File.separator, fast, children);
                }
            }
            if (fast) continue;
            this.scandir(file, name + File.separator, fast, children);
        }
    }

    private void accountForIncludedFile(String name, File file) {
        this.processIncluded(name, file, this.filesIncluded, this.filesExcluded, this.filesDeselected);
    }

    private void accountForIncludedDir(String name, File file, boolean fast) {
        this.processIncluded(name, file, this.dirsIncluded, this.dirsExcluded, this.dirsDeselected);
        if (fast && this.couldHoldIncluded(name) && !this.contentsExcluded(name)) {
            this.scandir(file, name + File.separator, fast);
        }
    }

    private void accountForIncludedDir(String name, File file, boolean fast, String[] children) {
        this.processIncluded(name, file, this.dirsIncluded, this.dirsExcluded, this.dirsDeselected);
        if (fast && this.couldHoldIncluded(name) && !this.contentsExcluded(name)) {
            this.scandir(file, name + File.separator, fast, children);
        }
    }

    private void processIncluded(String name, File file, Vector<String> inc, Vector<String> exc, Vector<String> des) {
        if (inc.contains(name) || exc.contains(name) || des.contains(name)) {
            return;
        }
        boolean included = false;
        if (this.isExcluded(name)) {
            exc.add(name);
        } else if (this.isSelected(name, file)) {
            included = true;
            inc.add(name);
        } else {
            des.add(name);
        }
        this.everythingIncluded &= included;
    }

    protected boolean isIncluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.includeNonPatterns.contains(name) : this.includeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        for (int i = 0; i < this.includePatterns.length; ++i) {
            if (!DirectoryScanner.matchPath(this.includePatterns[i], name, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!DirectoryScanner.matchPatternStart(this.includes[i], name, this.isCaseSensitive()) || !this.isMorePowerfulThanExcludes(name, this.includes[i]) || !this.isDeeper(this.includes[i], name)) continue;
            return true;
        }
        return false;
    }

    private boolean isDeeper(String pattern, String name) {
        Vector p = SelectorUtils.tokenizePath(pattern);
        Vector n = SelectorUtils.tokenizePath(name);
        return p.contains("**") || p.size() > n.size();
    }

    private boolean isMorePowerfulThanExcludes(String name, String includepattern) {
        String soughtexclude = name + File.separator + "**";
        for (int counter = 0; counter < this.excludes.length; ++counter) {
            if (!this.excludes[counter].equals(soughtexclude)) continue;
            return false;
        }
        return true;
    }

    private boolean contentsExcluded(String name) {
        name = name.endsWith(File.separator) ? name : name + File.separator;
        for (int i = 0; i < this.excludes.length; ++i) {
            String e = this.excludes[i];
            if (!e.endsWith("**") || !SelectorUtils.matchPath(e.substring(0, e.length() - 2), name, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.excludeNonPatterns.contains(name) : this.excludeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        for (int i = 0; i < this.excludePatterns.length; ++i) {
            if (!DirectoryScanner.matchPath(this.excludePatterns[i], name, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelected(String name, File file) {
        if (this.selectors != null) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (this.selectors[i].isSelected(this.basedir, name, file)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized String[] getIncludedFiles() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        Object[] files = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(files);
        Arrays.sort(files);
        return files;
    }

    public synchronized int getIncludedFilesCount() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        return this.filesIncluded.size();
    }

    @Override
    public synchronized String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(files);
        return files;
    }

    @Override
    public synchronized String[] getExcludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(files);
        return files;
    }

    @Override
    public synchronized String[] getDeselectedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(files);
        return files;
    }

    @Override
    public synchronized String[] getIncludedDirectories() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        Object[] directories = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(directories);
        Arrays.sort(directories);
        return directories;
    }

    public synchronized int getIncludedDirsCount() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        return this.dirsIncluded.size();
    }

    @Override
    public synchronized String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(directories);
        return directories;
    }

    @Override
    public synchronized String[] getExcludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(directories);
        return directories;
    }

    @Override
    public synchronized String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(directories);
        return directories;
    }

    @Override
    public synchronized void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + defaultExcludes.size()];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        String[] defaultExcludesTemp = DirectoryScanner.getDefaultExcludes();
        for (int i = 0; i < defaultExcludesTemp.length; ++i) {
            newExcludes[i + excludesLength] = defaultExcludesTemp[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        this.excludes = newExcludes;
    }

    private String[] list(File file) {
        String[] files = this.fileListMap.get(file);
        if (files == null && (files = file.list()) != null) {
            this.fileListMap.put(file, files);
        }
        return files;
    }

    private File findFile(File base, String path, boolean cs) {
        if (FileUtils.isAbsolutePath(path)) {
            if (base == null) {
                String[] s = FILE_UTILS.dissect(path);
                base = new File(s[0]);
                path = s[1];
            } else {
                File f = FILE_UTILS.normalize(path);
                String s = FILE_UTILS.removeLeadingPath(base, f);
                if (s.equals(f.getAbsolutePath())) {
                    return null;
                }
                path = s;
            }
        }
        return this.findFile(base, SelectorUtils.tokenizePath(path), cs);
    }

    private File findFile(File base, Vector<String> pathElements, boolean cs) {
        if (pathElements.size() == 0) {
            return base;
        }
        String current = pathElements.remove(0);
        if (base == null) {
            return this.findFile(new File(current), pathElements, cs);
        }
        if (!base.isDirectory()) {
            return null;
        }
        String[] files = this.list(base);
        if (files == null) {
            throw new DirectoryScannerException("IO error scanning directory " + base.getAbsolutePath());
        }
        boolean[] matchCase = cs ? CS_SCAN_ONLY : CS_THEN_NON_CS;
        for (int i = 0; i < matchCase.length; ++i) {
            for (int j = 0; j < files.length; ++j) {
                if (!(matchCase[i] ? files[j].equals(current) : files[j].equalsIgnoreCase(current))) continue;
                return this.findFile(new File(base, files[j]), pathElements, cs);
            }
        }
        return null;
    }

    private boolean isSymlink(File base, String path) {
        return this.isSymlink(base, SelectorUtils.tokenizePath(path));
    }

    private boolean isSymlink(File base, Vector<String> pathElements) {
        if (pathElements.size() > 0) {
            String current = pathElements.remove(0);
            try {
                return FILE_UTILS.isSymbolicLink(base, current) || this.isSymlink(new File(base, current), pathElements);
            }
            catch (IOException ioe) {
                String msg = "IOException caught while checking for links, couldn't get canonical path!";
                System.err.println(msg);
            }
        }
        return false;
    }

    private boolean hasBeenScanned(String vpath) {
        return !this.scannedDirs.add(vpath);
    }

    Set<String> getScannedDirs() {
        return this.scannedDirs;
    }

    private synchronized void clearCaches() {
        this.fileListMap.clear();
        this.includeNonPatterns.clear();
        this.excludeNonPatterns.clear();
        this.includePatterns = null;
        this.excludePatterns = null;
        this.areNonPatternSetsReady = false;
    }

    private synchronized void ensureNonPatternSetsReady() {
        if (!this.areNonPatternSetsReady) {
            this.includePatterns = this.fillNonPatternSet(this.includeNonPatterns, this.includes);
            this.excludePatterns = this.fillNonPatternSet(this.excludeNonPatterns, this.excludes);
            this.areNonPatternSetsReady = true;
        }
    }

    private String[] fillNonPatternSet(Set<String> set, String[] patterns) {
        ArrayList<String> al = new ArrayList<String>(patterns.length);
        for (int i = 0; i < patterns.length; ++i) {
            if (!SelectorUtils.hasWildcards(patterns[i])) {
                set.add(this.isCaseSensitive() ? patterns[i] : patterns[i].toUpperCase());
                continue;
            }
            al.add(patterns[i]);
        }
        return set.size() == 0 ? patterns : al.toArray(new String[al.size()]);
    }

    static {
        DirectoryScanner.resetDefaultExcludes();
    }
}

