/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import com.google.jstestdriver.Flags;
import com.google.jstestdriver.guice.GuiceBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

public class FlagBinder {
    private final Flags flags;

    public FlagBinder(Flags flags) {
        this.flags = flags;
    }

    public void bind(Binder binder) {
        for (Method method : Flags.class.getMethods()) {
            GuiceBinding annotation = method.getAnnotation(GuiceBinding.class);
            if (annotation == null) continue;
            try {
                Object value = method.invoke((Object)this.flags, new Object[0]);
                binder.bind(this.resolveClass(annotation, method.getReturnType())).toProvider(Providers.of(value));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Key resolveClass(GuiceBinding annotation, Class returnType) {
        Named named = Names.named(annotation.name());
        if (List.class.isAssignableFrom(returnType)) {
            if (annotation.parameterizedType() == GuiceBinding.NullClass.class) {
                throw new IllegalArgumentException("Missing parameterized type for " + annotation);
            }
            return Key.get((Type)Types.listOf(annotation.parameterizedType()), (Annotation)named);
        }
        return Key.get(returnType, (Annotation)named);
    }
}

